@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12 text-right">
            <h2>Transferências - Consultar</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" value="{{ ($datafiltro['datade']) }}" />
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" value="{{ ($datafiltro['dataate']) }}" />
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Situação
                                </div>
                                <div class="col-md-8">
                                    <select name="filtrostatus" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="0" {{ ($datafiltro['filtrostatus'] == '0')?'selected':'' }}>Aguardando</option>
                                        <option value="Paid" {{ ($datafiltro['filtrostatus'] == 'Paid')?'selected':'' }}>Pago</option>
                                        <option value="Cancel" {{ ($datafiltro['filtrostatus'] == 'Cancel')?'selected':'' }}>Cancelado</option>
                                        <option value="Registered" {{ ($datafiltro['filtrostatus'] == 'Registered')?'selected':'' }}>Registrado</option>
                                        <option value="Rejected" {{ ($datafiltro['filtrostatus'] == 'Rejected')?'selected':'' }}>Rejeitado</option>
                                        <option value="ErrorBalance" {{ ($datafiltro['filtrostatus'] == 'ErrorBalance')?'selected':'' }}>Erro de saldo</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Tipo
                                </div>
                                <div class="col-md-8">
                                    <select name="method" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="InternalTransfer"   {{ ($datafiltro['filtroMetodo'] == 'InternalTransfer' )?'selected':'' }}>Para o cliente</option>
                                        <option value="MoneyTransferIn" {{ ($datafiltro['filtroMetodo'] == 'MoneyTransferIn' )?'selected':'' }}>Para a SPS</option>
                                    </select>
                                </div>
                            </div>
                        </div> {{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Período: {{ ($datafiltro['datade']) }} a {{ ($datafiltro['dataate']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div> 

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center">
                                        Data
                                    </th>
                                    <th class="text-center">
                                        Usuário
                                    </th>
                                    <th class="text-center">
                                        Cliente
                                    </th>
                                    <th class="text-center">
                                        Status
                                    </th>
                                    <th class="text-center">
                                        Mensagem
                                    </th>
                                    <th class="text-center">
                                        ID
                                    </th>
                                    <th class="text-center">
                                        Valor
                                    </th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tlogs as $tlog)
                                    <?php $cliente = getClientById($tlog->client_id) ?>
                                    <?php $user = getUserById($tlog->user_id) ?>
                                    <tr>
                                        <th class="text-nowrap" scope="row">{{ datetime2br($tlog->actiondate) }}</th>
                                        <td class="text-nowrap">{{ (!$user)?'INTERNAL':$user->name }}</td>
                                        <td class="text-nowrap">{{ (!$cliente)?'SPS':$cliente->name }}</td>
                                        <td>{!! ($tlog->method == 'InternalTransfer')? (($tlog->success==0)?'<span class="text-danger">Falha</span>':'<span class="text-success">Realizada</span>') : traduzStatus($tlog->status) !!}</td>
                                        <td>{{ $tlog->message }}</td>
                                        <td>{{ $tlog->entry }}</td>
                                        <td>{{ formatMoneyBr($tlog->balance) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }
    </script>
@endsection

