@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>
    <script src="{{ asset('js/jquery.maskMoney.min.js') }}"></script>
@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12 text-right">
            <h2>Mensalidades</h2>
        </div>
    </div>
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <?php $anoatual = date('Y');?>
                                <div class="col-md-4">
                                    <select name="mesde" class="form-control">
                                        <option value="01" {{ ($filtro['mesde'] == '01' )?'selected':'' }}>Janeiro</option>
                                        <option value="02" {{ ($filtro['mesde'] == '02' )?'selected':'' }}>Fevereiro</option>
                                        <option value="03" {{ ($filtro['mesde'] == '03' )?'selected':'' }}>Março</option>
                                        <option value="04" {{ ($filtro['mesde'] == '04' )?'selected':'' }}>Abril</option>
                                        <option value="05" {{ ($filtro['mesde'] == '05' )?'selected':'' }}>Maio</option>
                                        <option value="06" {{ ($filtro['mesde'] == '06' )?'selected':'' }}>Junho</option>
                                        <option value="07" {{ ($filtro['mesde'] == '07' )?'selected':'' }}>Julho</option>
                                        <option value="08" {{ ($filtro['mesde'] == '08' )?'selected':'' }}>Agosto</option>
                                        <option value="09" {{ ($filtro['mesde'] == '09' )?'selected':'' }}>Setembro</option>
                                        <option value="10" {{ ($filtro['mesde'] == '10' )?'selected':'' }}>Outubro</option>
                                        <option value="11" {{ ($filtro['mesde'] == '11' )?'selected':'' }}>Novembro</option>
                                        <option value="12" {{ ($filtro['mesde'] == '12' )?'selected':'' }}>Dezembro</option>
                                    </select>
                                </div>
                                <div class="col-md-4">

                                    <select name="anode" class="form-control">
                                        <option value="{{ ($anoatual - 0) }}" {{ ($filtro['anode'] == ($anoatual - 0) )?'selected':'' }}>{{ ($anoatual - 0) }}</option>
                                        <option value="{{ ($anoatual - 1) }}" {{ ($filtro['anode'] == ($anoatual - 1) )?'selected':'' }}>{{ ($anoatual - 1) }}</option>
                                        <option value="{{ ($anoatual - 2) }}" {{ ($filtro['anode'] == ($anoatual - 2) )?'selected':'' }}>{{ ($anoatual - 2) }}</option>
                                        <option value="{{ ($anoatual - 3) }}" {{ ($filtro['anode'] == ($anoatual - 3) )?'selected':'' }}>{{ ($anoatual - 3) }}</option>
                                        <option value="{{ ($anoatual - 4) }}" {{ ($filtro['anode'] == ($anoatual - 4) )?'selected':'' }}>{{ ($anoatual - 4) }}</option>
                                    </select>

                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-4">
                                    <select name="mesate" class="form-control">
                                        <option value="01" {{ ($filtro['mesate'] == '01' )?'selected':'' }}>Janeiro</option>
                                        <option value="02" {{ ($filtro['mesate'] == '02' )?'selected':'' }}>Fevereiro</option>
                                        <option value="03" {{ ($filtro['mesate'] == '03' )?'selected':'' }}>Março</option>
                                        <option value="04" {{ ($filtro['mesate'] == '04' )?'selected':'' }}>Abril</option>
                                        <option value="05" {{ ($filtro['mesate'] == '05' )?'selected':'' }}>Maio</option>
                                        <option value="06" {{ ($filtro['mesate'] == '06' )?'selected':'' }}>Junho</option>
                                        <option value="07" {{ ($filtro['mesate'] == '07' )?'selected':'' }}>Julho</option>
                                        <option value="08" {{ ($filtro['mesate'] == '08' )?'selected':'' }}>Agosto</option>
                                        <option value="09" {{ ($filtro['mesate'] == '09' )?'selected':'' }}>Setembro</option>
                                        <option value="10" {{ ($filtro['mesate'] == '10' )?'selected':'' }}>Outubro</option>
                                        <option value="11" {{ ($filtro['mesate'] == '11' )?'selected':'' }}>Novembro</option>
                                        <option value="12" {{ ($filtro['mesate'] == '12' )?'selected':'' }}>Dezembro</option>
                                    </select>
                                </div>
                                <div class="col-md-4">

                                    <select name="anode" class="form-control">
                                        <option value="{{ ($anoatual - 0) }}" {{ ($filtro['anoate'] == ($anoatual - 0) )?'selected':'' }}>{{ ($anoatual - 0) }}</option>
                                        <option value="{{ ($anoatual - 1) }}" {{ ($filtro['anoate'] == ($anoatual - 1) )?'selected':'' }}>{{ ($anoatual - 1) }}</option>
                                        <option value="{{ ($anoatual - 2) }}" {{ ($filtro['anoate'] == ($anoatual - 2) )?'selected':'' }}>{{ ($anoatual - 2) }}</option>
                                        <option value="{{ ($anoatual - 3) }}" {{ ($filtro['anoate'] == ($anoatual - 3) )?'selected':'' }}>{{ ($anoatual - 3) }}</option>
                                        <option value="{{ ($anoatual - 4) }}" {{ ($filtro['anoate'] == ($anoatual - 4) )?'selected':'' }}>{{ ($anoatual - 4) }}</option>
                                    </select>

                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Situação
                                </div>
                                <div class="col-md-8">
                                    <select name="filtrostatus" class="form-control">
                                        <option value="">Selecione</option>
                                        <option value="0" {{ ($filtro['filtrostatus'] == '0')?'selected':'' }}>Aberto</option>
                                        <option value="1" {{ ($filtro['filtrostatus'] == '1')?'selected':'' }}>Pago</option>
                                        <option value="2" {{ ($filtro['filtrostatus'] == '2')?'selected':'' }}>Cancelado</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Cliente
                                </div>
                                <div class="col-md-8">
                                    <?php $clientes = getClients(); ?>
                                    <select name="filtrocliente" class="form-control">
                                        <option value="">Selecione</option>
                                        @foreach($clientes as $cli)
                                            <option value="{{ $cli->id }}" {{ ($filtro['filtrocliente'] == $cli->id )?'selected':'' }}>{{ $cli->name }}</option>}
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Ordenação
                                </div>
                                <div class="col-md-8">
                                    <select name="filtroordem" class="form-control">
                                        <option value="">Cliente</option>
                                        <option value="monthlyfeepayments.status" {{ ($filtro['filtroordem'] == 'monthlyfeepayments.status')?'selected':'' }}>Situação</option>
                                        <option value="monthlyfeepayments.duedate" {{ ($filtro['filtroordem'] == 'monthlyfeepayments.duedate')?'selected':'' }}>Vencimento</option>
                                        <option value="monthlyfeepayments.paymentdate" {{ ($filtro['filtroordem'] == 'monthlyfeepayments.paymentdate')?'selected':'' }}>Pagamento</option>
                                        <option value="monthlyfeepayments.value" {{ ($filtro['filtroordem'] == 'monthlyfeepayments.value')?'selected':'' }}>Valor</option>
                                    </select>
                                </div>
                            </div>

                        </div> {{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Período: {{ (getMes($filtro['mesde']).'/'.$filtro['anode']) }} a {{ (getMes($filtro['mesate']).'/'.$filtro['anoate']) }}</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center">
                                        Cliente
                                    </th>
                                    <th class="text-center">
                                        Vencimento
                                    </th>
                                    <th class="text-center">
                                        Pagamento
                                    </th>
                                    <th class="text-center">
                                        Status
                                    </th>
                                    <th class="text-center">
                                        Valor
                                    </th>
                                    <th class="text-center">
                                        Obs.
                                    </th>
                                    <th class="text-center">

                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $totalvalue = 0;?>
                                @foreach($mensalidades as $mens)
                                    <tr>
                                        <td class="text-nowrap">{{ $mens->nickname }}</td>
                                        <th class="text-nowrap text-center" scope="row">{{ detectDateFormatOutputDateBr($mens->emission) }}</th>
                                        <th class="text-nowrap text-center" scope="row">{{ detectDateFormatOutputDateBr($mens->paymentdate) }}</th>
                                        <td class="text-nowrap text-center text-bold-600">{!! ($mens->status==1)?'<span class="text-success">Pago</span>':'<span class="text-info">Aberto</span>' !!}</td>
                                        <td class="text-nowrap text-right">R$ {{ formatMoneyBr($mens->requestedvalue) }}</td>
                                        <td>{{ $mens->details }}</td>
                                        <td>
                                            @if($mens->status==0)
                                                <button type="button" class="btn btn-icon btn-outline-success btn-sm waves-effect waves-light" data-toggle="modal" data-target="#editarmensalidade{{ $mens->id }}">
                                                    <i class="feather icon-edit-1"></i>
                                                </button>
                                            @endif
                                        </td>
                                    </tr>
                                    <?php $totalvalue += ($mens->status == 'Paid')?$mens->value:0;?>


                                    @if($mens->status==0)
                                        {{-- MODAL EDITAR --}}
                                        <div class="modal fade" id="editarmensalidade{{ $mens->id }}" tabindex="-1" role="dialog" aria-labelledby="editarmensalidadeTitle" aria-modal="true">
                                            <div class="modal-dialog modal-dialog-centered modal-dialog-centered modal-dialog-scrollable modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalCenterTitle">Editar informações</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">×</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <br><br>
                                                        <form action="{{ url('/mensalidades/editar') }}" method="POST">
                                                            @csrf
                                                            <input type="hidden" name="id" value="{{ $mens->id }}">

                                                            <div class="col-12">
                                                                <div class="form-group row">
                                                                    <div class="col-md-4">
                                                                        <span>Novo vencimento</span>
                                                                    </div>
                                                                    <div class="col-md-8">
                                                                        <input type="text" name="newduedate" id="newduedate" class="form-control newduedate" value="{{ detectDateFormatOutputDateBr($mens->duedate) }}" />
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-12">
                                                                <div class="form-group row">
                                                                    <div class="col-md-4">
                                                                        <span>Valor</span>
                                                                    </div>
                                                                    <div class="col-md-8">
                                                                        <input type="text" name="newvalue" id="newvalue" class="form-control newvalue" value="{{ formatMoneyBr($mens->value) }}" />
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="col-12">
                                                                <div class="form-group row">
                                                                    <div class="col-md-4">
                                                                        <span>Obs.</span>
                                                                    </div>
                                                                    <div class="col-md-8">
                                                                        <input type="text" name="details" id="details" class="form-control"/>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                    </div>
                                                    <br><br>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-outline-dark waves-effect waves-light" data-dismiss="modal">Cancelar</button>
                                                        <button type="submit" class="btn btn-success waves-effect waves-light"> Salvar </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {{-- //MODAL EDITAR --}}
                                    @endif

                                @endforeach
                                    <tr class="table-tr-border-top">
                                        <td class="text-nowrap text-right" colspan="4">Total recebido no período</td>
                                        <td class="text-nowrap text-right text-bold-600">R$ {{ formatMoneyBr($totalvalue) }}</td>
                                        <td colspan="2"></td>
                                    </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        $(function() {
            $('.newvalue').maskMoney({
                prefix:'',
                allowNegative: false,
                thousands:'.',
                decimal:',',
                affixesStay: false,
                allowZero: true
            });
        });

        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.newduedate').pickadate(pickerOpt);

    </script>
@endsection

