@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12 text-right">
            <h2>Relatório Comparativo</h2>
        </div>
    </div>
    <div class="row justify-content-md-center no-print">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    
                    <?php $anoatual = date('Y')?>
                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Mês/ano
                                </div>
                                <div class="col-md-8">
                                    <div class="row">
                                        <select name="filtromes1" class="form-control col-md-7">
                                            <option value="00" {{ ($filtros['filtromes1'] == '00')?'selected':'' }}>Todos</option>
                                            <option value="01" {{ ($filtros['filtromes1'] == '01')?'selected':'' }}>Janeiro</option>
                                            <option value="02" {{ ($filtros['filtromes1'] == '02')?'selected':'' }}>Fevereiro</option>
                                            <option value="03" {{ ($filtros['filtromes1'] == '03')?'selected':'' }}>Março</option>
                                            <option value="04" {{ ($filtros['filtromes1'] == '04')?'selected':'' }}>Abril</option>
                                            <option value="05" {{ ($filtros['filtromes1'] == '05')?'selected':'' }}>Maio</option>
                                            <option value="06" {{ ($filtros['filtromes1'] == '06')?'selected':'' }}>Junho</option>
                                            <option value="07" {{ ($filtros['filtromes1'] == '07')?'selected':'' }}>Julho</option>
                                            <option value="08" {{ ($filtros['filtromes1'] == '08')?'selected':'' }}>Agosto</option>
                                            <option value="09" {{ ($filtros['filtromes1'] == '09')?'selected':'' }}>Setembro</option>
                                            <option value="10" {{ ($filtros['filtromes1'] == '10')?'selected':'' }}>Outubro</option>
                                            <option value="11" {{ ($filtros['filtromes1'] == '11')?'selected':'' }}>Novembro</option>
                                            <option value="12" {{ ($filtros['filtromes1'] == '12')?'selected':'' }}>Dezembro</option>
                                        </select>

                                        <select name="filtroano1" class="form-control col-md-5">
                                            <option value="{{ $anoatual-2 }}" {{ ($filtros['filtroano1'] == $anoatual-2)?'selected':'' }}>{{ $anoatual-2 }}</option>
                                            <option value="{{ $anoatual-1 }}" {{ ($filtros['filtroano1'] == $anoatual-1)?'selected':'' }}>{{ $anoatual-1 }}</option>
                                            <option value="{{ $anoatual }}"   {{ ($filtros['filtroano1'] == $anoatual)?'selected':'' }}>{{ $anoatual }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Mês/ano
                                </div>
                                <div class="col-md-8">
                                    <div class="row">
                                        <select name="filtromes2" class="form-control col-md-7">
                                            <option value="00" {{ ($filtros['filtromes2'] == '00')?'selected':'' }}>Todos</option>
                                            <option value="01" {{ ($filtros['filtromes2'] == '01')?'selected':'' }}>Janeiro</option>
                                            <option value="02" {{ ($filtros['filtromes2'] == '02')?'selected':'' }}>Fevereiro</option>
                                            <option value="03" {{ ($filtros['filtromes2'] == '03')?'selected':'' }}>Março</option>
                                            <option value="04" {{ ($filtros['filtromes2'] == '04')?'selected':'' }}>Abril</option>
                                            <option value="05" {{ ($filtros['filtromes2'] == '05')?'selected':'' }}>Maio</option>
                                            <option value="06" {{ ($filtros['filtromes2'] == '06')?'selected':'' }}>Junho</option>
                                            <option value="07" {{ ($filtros['filtromes2'] == '07')?'selected':'' }}>Julho</option>
                                            <option value="08" {{ ($filtros['filtromes2'] == '08')?'selected':'' }}>Agosto</option>
                                            <option value="09" {{ ($filtros['filtromes2'] == '09')?'selected':'' }}>Setembro</option>
                                            <option value="10" {{ ($filtros['filtromes2'] == '10')?'selected':'' }}>Outubro</option>
                                            <option value="11" {{ ($filtros['filtromes2'] == '11')?'selected':'' }}>Novembro</option>
                                            <option value="12" {{ ($filtros['filtromes2'] == '12')?'selected':'' }}>Dezembro</option>
                                        </select>

                                        <select name="filtroano2" class="form-control col-md-5">
                                            <option value="{{ $anoatual-2 }}" {{ ($filtros['filtroano2'] == $anoatual-2)?'selected':'' }}>{{ $anoatual-2 }}</option>
                                            <option value="{{ $anoatual-1 }}" {{ ($filtros['filtroano2'] == $anoatual-1)?'selected':'' }}>{{ $anoatual-1 }}</option>
                                            <option value="{{ $anoatual }}"   {{ ($filtros['filtroano2'] == $anoatual)?'selected':'' }}>{{ $anoatual }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Cliente
                                </div>
                                <div class="col-md-8">
                                    <select name="client_id" class="form-control">
                                        <option value="">Todos</option>
                                        @foreach($clients as $client)
                                            <option value="{{ $client->id }}" {{ ($filtros['filtroCliente'] == $client->id )?'selected':'' }}>{{ $client->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            
                        </div>{{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                </form>
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Comparando: {{ (getMes($filtros['filtromes1']).'/'.$filtros['filtroano1']) }} e {{ (getMes($filtros['filtromes2']).'/'.$filtros['filtroano2']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div> 

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Column Chart -->
                        <div class="col-lg-8 col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Pago ao FitBank</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <div id="column-chart"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Total</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <?php $totalFit1 = $relatorio['param1']['darf']['fitvalue']+
                                                    $relatorio['param1']['darj']['fitvalue']+
                                                    $relatorio['param1']['fgts']['fitvalue']+
                                                    $relatorio['param1']['gps']['fitvalue']+
                                                    $relatorio['param1']['gare']['fitvalue']+
                                                    $relatorio['param1']['barcodepayment']['fitvalue']+
                                                    $relatorio['param1']['transfer']['fitvalue']+
                                                    $relatorio['param1']['billets']['fitvalue']+
                                                    $relatorio['param1']['monthlyfee']['fitvalue']+
                                                    $relatorio['param1']['availablelimit']['fitvalue'];

                                                $totalFit2 = $relatorio['param1']['darf']['fitvalue']+
                                                    $relatorio['param2']['darj']['fitvalue']+
                                                    $relatorio['param2']['fgts']['fitvalue']+
                                                    $relatorio['param2']['gps']['fitvalue']+
                                                    $relatorio['param2']['gare']['fitvalue']+
                                                    $relatorio['param2']['barcodepayment']['fitvalue']+
                                                    $relatorio['param2']['transfer']['fitvalue']+
                                                    $relatorio['param2']['billets']['fitvalue']+
                                                    $relatorio['param2']['monthlyfee']['fitvalue']+
                                                    $relatorio['param2']['availablelimit']['fitvalue'];
                                        ?>

                                        <p>{{ (getMes($filtros['filtromes1']).'/'.$filtros['filtroano1']) }}: <b class="text-info">R$ {{ $totalFit1 }}</b></p>
                                        <p>{{ (getMes($filtros['filtromes2']).'/'.$filtros['filtroano2']) }}: <b class="text-info">R$ {{ $totalFit2 }}</b></p>
                                        <hr>
                                        <b class="pull-right">R$ {{ $totalFit1+$totalFit2 }}</b>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <!-- Column Chart -->
                        <div class="col-lg-8 col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Recebido dos clientes</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <div id="column-chart2"></div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Total</h4>
                                </div>
                                <div class="card-content">
                                    <div class="card-body">
                                        <?php $totalCli1 = $relatorio['param1']['darf']['totalvalue']+
                                                    $relatorio['param1']['darj']['totalvalue']+
                                                    $relatorio['param1']['fgts']['totalvalue']+
                                                    $relatorio['param1']['gps']['totalvalue']+
                                                    $relatorio['param1']['gare']['totalvalue']+
                                                    $relatorio['param1']['barcodepayment']['totalvalue']+
                                                    $relatorio['param1']['transfer']['totalvalue']+
                                                    $relatorio['param1']['billets']['totalvalue']+
                                                    $relatorio['param1']['monthlyfee']['totalvalue']+
                                                    $relatorio['param1']['availablelimit']['totalvalue'];

                                                $totalCli2 = $relatorio['param1']['darf']['totalvalue']+
                                                    $relatorio['param2']['darj']['totalvalue']+
                                                    $relatorio['param2']['fgts']['totalvalue']+
                                                    $relatorio['param2']['gps']['totalvalue']+
                                                    $relatorio['param2']['gare']['totalvalue']+
                                                    $relatorio['param2']['barcodepayment']['totalvalue']+
                                                    $relatorio['param2']['transfer']['totalvalue']+
                                                    $relatorio['param2']['billets']['totalvalue']+
                                                    $relatorio['param2']['monthlyfee']['totalvalue']+
                                                    $relatorio['param2']['availablelimit']['totalvalue'];
                                        ?>

                                        <p>{{ (getMes($filtros['filtromes1']).'/'.$filtros['filtroano1']) }}: <b class="text-info">R$ {{ $totalCli1 }}</b></p>
                                        <p>{{ (getMes($filtros['filtromes2']).'/'.$filtros['filtroano2']) }}: <b class="text-info">R$ {{ $totalCli2 }}</b></p>
                                        <hr>
                                        <b class="pull-right">R$ {{ $totalCli1+$totalCli2 }}</b>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }

        // Column Chart
        // ----------------------------------
        var $primary = '#7367F0',
            $success = '#28C76F',
            $danger = '#EA5455',
            $warning = '#FF9F43',
            $info = '#00cfe8',
            $label_color_light = '#dae1e7';

        var themeColors = [$primary, $success, $danger, $warning, $info];

        // RTL Support
        var yaxis_opposite = false;
        if($('html').data('textdirection') == 'rtl'){
            yaxis_opposite = true;
        }

        var columnChartOptions = {
            chart: {
              height: 450,
              type: 'bar',
            },
            colors: themeColors,
            plotOptions: {
              bar: {
                horizontal: false,
                endingShape: 'rounded',
                columnWidth: '55%',
              },
            },
            dataLabels: {
              enabled: false
            },
            stroke: {
              show: true,
              width: 2,
              colors: ['transparent']
            },
            series: [{
              name: '{{ (getMes($filtros['filtromes1']).'/'.$filtros['filtroano1']) }}',
              data: [
                {{ $relatorio['param1']['darf']['fitvalue'] }},
                {{ $relatorio['param1']['darj']['fitvalue'] }},
                {{ $relatorio['param1']['fgts']['fitvalue'] }},
                {{ $relatorio['param1']['gps']['fitvalue'] }},
                {{ $relatorio['param1']['gare']['fitvalue'] }},
                {{ $relatorio['param1']['barcodepayment']['fitvalue'] }},
                {{ $relatorio['param1']['transfer']['fitvalue'] }},
                {{ $relatorio['param1']['billets']['fitvalue'] }},
                {{ $relatorio['param1']['monthlyfee']['fitvalue'] }},
                {{ $relatorio['param1']['availablelimit']['fitvalue'] }}
              ]
            }, {
              name: '{{ (getMes($filtros['filtromes2']).'/'.$filtros['filtroano2']) }}',
              data: [
                {{ $relatorio['param2']['darf']['fitvalue'] }},
                {{ $relatorio['param2']['darj']['fitvalue'] }},
                {{ $relatorio['param2']['fgts']['fitvalue'] }},
                {{ $relatorio['param2']['gps']['fitvalue'] }},
                {{ $relatorio['param2']['gare']['fitvalue'] }},
                {{ $relatorio['param2']['barcodepayment']['fitvalue'] }},
                {{ $relatorio['param2']['transfer']['fitvalue'] }},
                {{ $relatorio['param2']['billets']['fitvalue'] }},
                {{ $relatorio['param2']['monthlyfee']['fitvalue'] }},
                {{ $relatorio['param2']['availablelimit']['fitvalue'] }},
              ]
            }],
            legend: {
              offsetY: -10
            },
            xaxis: {
              // categories: ['Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
              categories: [
                'DARF',
                'DARJ',
                'FGTS',
                'GPS',
                'GARE',
                'Cod. Barras',
                'Transf.',
                'Boletos',
                'Mensalidade',
                'Lim. Disp.',
              ],
            },
            yaxis: {
              title: {
                text: 'R$'
              },
              opposite: yaxis_opposite
            },
            fill: {
              opacity: 1

            },
            tooltip: {
              y: {
                formatter: function (val) {
                  return "R$ " + val
                }
              }
            }
          }
          var columnChart = new ApexCharts(
            document.querySelector("#column-chart"),
            columnChartOptions
          );

          columnChart.render();


          /*************** Grafico 2 ***************/
          var columnChartOptions2 = {
            chart: {
              height: 450,
              type: 'bar',
            },
            colors: themeColors,
            plotOptions: {
              bar: {
                horizontal: false,
                endingShape: 'rounded',
                columnWidth: '55%',
              },
            },
            dataLabels: {
              enabled: false
            },
            stroke: {
              show: true,
              width: 2,
              colors: ['transparent']
            },
            series: [{
              name: '{{ (getMes($filtros['filtromes1']).'/'.$filtros['filtroano1']) }}',
              data: [
                {{ $relatorio['param1']['darf']['totalvalue'] }},
                {{ $relatorio['param1']['darj']['totalvalue'] }},
                {{ $relatorio['param1']['fgts']['totalvalue'] }},
                {{ $relatorio['param1']['gps']['totalvalue'] }},
                {{ $relatorio['param1']['gare']['totalvalue'] }},
                {{ $relatorio['param1']['barcodepayment']['totalvalue'] }},
                {{ $relatorio['param1']['transfer']['totalvalue'] }},
                {{ $relatorio['param1']['billets']['totalvalue'] }},
                {{ $relatorio['param1']['monthlyfee']['totalvalue'] }},
                {{ $relatorio['param1']['availablelimit']['totalvalue'] }}
              ]
            }, {
              name: '{{ (getMes($filtros['filtromes2']).'/'.$filtros['filtroano2']) }}',
              data: [
                {{ $relatorio['param2']['darf']['totalvalue'] }},
                {{ $relatorio['param2']['darj']['totalvalue'] }},
                {{ $relatorio['param2']['fgts']['totalvalue'] }},
                {{ $relatorio['param2']['gps']['totalvalue'] }},
                {{ $relatorio['param2']['gare']['totalvalue'] }},
                {{ $relatorio['param2']['barcodepayment']['totalvalue'] }},
                {{ $relatorio['param2']['transfer']['totalvalue'] }},
                {{ $relatorio['param2']['billets']['totalvalue'] }},
                {{ $relatorio['param2']['monthlyfee']['totalvalue'] }},
                {{ $relatorio['param2']['availablelimit']['totalvalue'] }},
              ]
            }],
            legend: {
              offsetY: -10
            },
            xaxis: {
              // categories: ['Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
              categories: [
                'DARF',
                'DARJ',
                'FGTS',
                'GPS',
                'GARE',
                'Cod. Barras',
                'Transf.',
                'Boletos',
                'Mensalidade',
                'Lim. Disp.',
              ],
            },
            yaxis: {
              title: {
                text: 'R$'
              },
              opposite: yaxis_opposite
            },
            fill: {
              opacity: 1

            },
            tooltip: {
              y: {
                formatter: function (val) {
                  return "R$ " + val
                }
              }
            }
          }
          var columnChart2 = new ApexCharts(
            document.querySelector("#column-chart2"),
            columnChartOptions2
          );

          columnChart2.render();
    </script>
@endsection

