@extends('layouts.authenticated')

@section('extracss')
    <link rel="stylesheet" href="{{ asset('css/vendors/css/pickers/pickadate/pickadate.css') }}">
@endsection

@section('extrajs')
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.date.js') }}"></script>
    <script src="{{ asset('js/vendors/js/pickers/pickadate/picker.time.js') }}"></script>
    <script src="{{ asset('js/js/scripts/pickers/dateTime/pick-a-datetime.js') }}"></script>

@endsection

@section('content')
<div class="container">
    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12 text-right">
            <h2>Relatório Tarifas - simples</h2>
        </div>
    </div>
    <div class="row justify-content-md-center no-print">
        <div class="col-md-12 col-12">
            <div class="card">
            <div class="card-body">
                <h3 class="text-center">Selecione os filtros</h3>

                <form class="form" onsubmit="validaForm()" method="POST">
                    @csrf
                <br>                    

                    <div class="form-body">
                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data início
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="datade" name="datade" class="form-control datepickerDe" placeholder="Data inicial" value="{{ ($filtros['datade']) }}" />
                                </div>
                            </div>
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Data fim
                                </div>
                                <div class="col-md-8">
                                    <input type='text' id="dataate" name="dataate" class="form-control datepickerAte" placeholder="Data final" value="{{ ($filtros['dataate']) }}" />
                                </div>
                            </div>
                        </div> {{-- row --}}

                        <div class="row">
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Cliente
                                </div>
                                <div class="col-md-8">
                                    <select name="client_id" class="form-control">
                                        <option value="">Todos</option>
                                        @foreach($clients as $client)
                                            <option value="{{ $client->id }}" {{ ($filtros['filtroCliente'] == $client->id )?'selected':'' }}>{{ $client->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-6 form-group row">
                                <div class="col-md-4 text-right">
                                    Mensalidade
                                </div>
                                <div class="col-md-8">
                                    <select name="mensalidade" class="form-control">
                                        <option value="1" {{ ($filtros['filtroMensalidade'] == 1 )?'selected':'' }}>Exibir</option>
                                        <option value="0" {{ ($filtros['filtroMensalidade'] == 0 )?'selected':'' }}>Esconder</option>
                                    </select>
                                </div>
                            </div>
                            
                        </div>{{-- row --}}
                    </div> {{-- form-body --}}
                    <div class="col-12 text-right"><button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">Filtrar</button></div>
                    
                </form>
               
            </div>
            </div>
        </div>
    </div>

    <div class="row justify-content-md-center">
        <div class="col-md-12 col-12">    
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-7 text-right">Período: {{ ($filtros['datade']) }} a {{ ($filtros['dataate']) }}</div>
                    </div>
                </div>    
            </div>    
        </div>    
    </div>

	<div class="row justify-content-md-center">
        <div class="col-md-12 col-12">
            <div class="card">
                <div class="col-12 text-right" style="margin-top: 10px;">
                    <form action="{{ url('/exporta/xls') }}" method="POST" target="_blank">
                        @csrf
                        <input type="hidden" name="client_id" value="{{ $filtros['filtroCliente'] }}">
                        <input type="hidden" name="datade" value="{{ $filtros['datade'] }}">
                        <input type="hidden" name="dataate" value="{{ $filtros['dataate'] }}">
                        <input type="hidden" name="mensalidade" value="{{ $filtros['filtroMensalidade'] }}">
                        <input type="submit" class="btn btn-outline-primary btn-sm mr-1 mb-1 waves-effect waves-light" value="Exportar XLS">
                    </form>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center">
                                        Tipo
                                    </th>
                                    <th class="text-center">
                                        Quantidade
                                    </th>
                                    <th class="text-center">
                                        Fitbank
                                    </th>
                                    <th class="text-center">
                                        Clientes
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $totalfit=0.0;?>
                                <?php $totalcli=0.0;?>
                                
                                @foreach($relatorio as $clirel)
                                    <tr class="table-tr-border-top">
                                        <th colspan="4" class="text-center font-medium-3" scope="row">{{ $clirel['client'] }}</th>
                                    </tr>

                                    <?php $totalfitcliente=0.0;?>
                                    <?php $totalclicliente=0.0;?>
                                    @foreach($clirel['report'] as $rel)
                                        <?php if($rel['show']==0) continue; ?>
                                        <tr>
                                            <td class="text-center">{{ $rel['type'] }}</td>
                                            <td class="text-center">{{ $rel['quantity'] }}</td>
                                            <td class="text-center text-danger">R$ {{ formatMoneyBr( $rel['fitvalue'] ) }}</td>
                                            <td class="text-center text-primary">R$ {{ formatMoneyBr( $rel['totalvalue'] ) }}</td>
                                        </tr>
                                        <?php $totalfit+=($rel['fitvalue']);?>
                                        <?php $totalcli+= $rel['totalvalue'];?>
                                        <?php $totalfitcliente+=($rel['fitvalue']);?>
                                        <?php $totalclicliente+= $rel['totalvalue'];?>
                                        
                                    @endforeach
                                    <tr class="table-tr-border-top font-small-3">
                                        <td class="text-right" colspan="2"><strong>Total cliente no período</strong></td>
                                        <td class="text-center text-danger">R$ <strong>{{ formatMoneyBr($totalfitcliente) }}</strong></td>
                                        <td class="text-center text-primary">R$ <strong>{{ formatMoneyBr($totalclicliente) }}</strong></td>
                                    </tr>
                                @endforeach
                                <tr class="table-tr-border-top">
                                    <td class="text-right" colspan="2"><strong>Total no período</strong></td>
                                    <td class="text-center text-danger">R$ <strong>{{ formatMoneyBr($totalfit) }}</strong></td>
                                    <td class="text-center text-primary">R$ <strong>{{ formatMoneyBr($totalcli) }}</strong></td>
                                </tr>
                                <tr class="table-tr-border-top">
                                    <td class="text-right" colspan="3"><strong>Diferença</strong></td>
                                    <td class="text-center {{ (($totalcli-$totalfit)>=0)?'text-success':'text-danger' }}">R$ <strong>{{ formatMoneyBr($totalcli-$totalfit) }}</strong></td>
                                </tr>



                                {{-- <?php $totalfit=0.0;?>
                                <?php $totalcli=0.0;?>
                                <?php $spsInfo = getSPS();?>
                                @foreach($relatorio as $rel)
                                    <tr>
                                        <td class="text-center">{{ $rel['type'] }}</td>
                                        <td class="text-center">{{ $rel['quantity'] }}</td>
                                        <td class="text-center text-danger">R$ {{ formatMoneyBr( (2 * $rel['quantity']) ) }}</td>
                                        <td class="text-center text-primary">R$ {!! formatMoneyBr( (3 * $rel['quantity']) ) !!}</td>
                                    </tr>
                                    <?php $totalfit+=(2 * $rel['quantity']);?>
                                    <?php $totalcli+=(3 * $rel['quantity']);?>
                                @endforeach
                                <tr class="table-tr-border-top">
                                    <td class="text-right" colspan="2"><strong>Total no período</strong></td>
                                    <td class="text-center text-danger">R$ <strong>{{ formatMoneyBr($totalfit) }}</strong></td>
                                    <td class="text-center text-primary">R$ <strong>{{ formatMoneyBr($totalcli) }}</strong></td>
                                </tr>
                                <tr class="table-tr-border-top">
                                    <td class="text-right" colspan="3"><strong>Diferença</strong></td>
                                    <td class="text-center {{ (($totalcli-$totalfit)>=0)?'text-success':'text-danger' }}">R$ <strong>{{ formatMoneyBr($totalcli-$totalfit) }}</strong></td>
                                </tr> --}}
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('inlinejs')
    <script type="text/javascript">
        var pickerOpt = {
            monthsFull: ['Janeiro', 'Fevereiro', 'Março', 'Abril', 'Maio', 'Junho', 'Julho', 'Agosto', 'Setembro', 'Outubro', 'Novembro', 'Dezembro'],
            monthsShort: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
            weekdaysFull: ['Domingo', 'Segunda', 'Terça', 'Quarta', 'Quinta', 'Sexta', 'Sábado'],
            weekdaysShort: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex', 'Sab'],
            today: 'Hoje',
            clear: 'Limpar',
            close: 'Fechar',
            labelMonthNext: 'Mês seg.',
            labelMonthPrev: 'Mês ant.',
            labelMonthSelect: 'Selecione um mês',
            labelYearSelect: 'Selecione um ano',
            format: 'dd/mm/yyyy',
            // formatSubmit: 'yyyy/mm/dd',
        };

        $('.datepickerDe').pickadate(pickerOpt);
        $('.datepickerAte').pickadate(pickerOpt);

        
        function validaForm() {
            var dataDe = document.getElementById('datade').value;
            var filtrode = new Date(dataDe);
            var dataAte = document.getElementById('dataate').value;
            var filtroate = new Date(dataAte);
            
            if(document.getElementById('datade').value == '' || document.getElementById('datade').value == '') {
                alert('Preencha as datas para filtrar.');
                return false;
            }

            if ( filtrode > filtroate ) { 
                alert('A data final não pode ser menor que a inicial.');
                return false;
            }
            return true;
        }
    </script>
@endsection

