<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});


Route::post('register', 'UserController@register');
Route::post('login', 'UserController@authenticate');
// Route::get('open', 'DataController@open');

Route::group(['middleware' => ['jwt.verify']], function() {
    Route::get('user', 'UserController@getAuthenticatedUser');
    Route::get('logout', 'UserController@logout');
    // Route::get('closed', 'DataController@closed');
    Route::get('home', 'HomeApiController@index');
    Route::get('extrato', 'ClientController@extrato');
    Route::get('contatos', 'ClientcontactController@contatos');
    Route::get('getmulticnpj', 'ClientController@getmulticnpj');
    Route::post('contatos/criar', 'ClientcontactController@criar');

    // serviços APP
    Route::post('servicos/consultadarf', 'ApiDarfController@consultaDarf');
    Route::post('servicos/consultadarj', 'ApiDarjController@consultaDarj');
    Route::post('servicos/consultafgts', 'ApiFgtsController@consultaFgts');
    Route::post('servicos/consultagps', 'ApiGpsController@consultaGps');
    Route::post('servicos/consultagare', 'ApiGareController@consultaGare');
    Route::post('servicos/consultatransferencia', 'ApiTransferenciaController@consultaTransferencia');
    Route::post('servicos/consultapagamento', 'ApiPagamentoController@consultaPagamento');
    Route::post('servicos/consultacodbarras', 'ApiPagamentoController@consultaCodbarras');
    Route::post('servicos/consultacomprovantes', 'ApiPagamentoController@consultaComprovantes');

    Route::post('servicos/enviadarf', 'ApiDarfController@enviaDarf');
    Route::post('servicos/enviadarj', 'ApiDarjController@enviaDarj');
    Route::post('servicos/enviafgts', 'ApiFgtsController@enviaFgts');
    Route::post('servicos/enviagps', 'ApiGpsController@enviaGps');
    Route::post('servicos/enviagare', 'ApiGareController@enviaGare');
    Route::post('servicos/enviatransferencia', 'ApiTransferenciaController@enviaTransferencia');
    Route::post('servicos/enviapagamento', 'ApiPagamentoController@enviaPagamento');
    
    Route::get('servicos/taxas', 'ClientController@userTaxes');
    Route::get('/clientesbyname','ClientWebController@clientesFiltradosPorNome');

    Route::resource('actionlogs','ActionlogController');
	Route::resource('addresses','AddressController');
	Route::resource('bankaccounts','BankaccountController');
	Route::resource('banks','BankController');
	Route::resource('clients','ClientController');
	Route::resource('detailedaccounts','DetailedaccountController');
	Route::resource('detailedindividualaccounts','DetailedindividualaccountController');
	Route::resource('documents','DocumentController');
	Route::resource('spsinfos','SpsinfoController');
	Route::resource('transactionlogs','TransactionlogController');

	Route::get('profile','UserController@profile');
});


Route::post('smartsafecollect/{cnpj}', 'ClientController@availablelimit');

// WEBHOOKS FITBANK
Route::post('webservices/cobrancaboletos', ['uses'=>'WebhookController@cobrancaboletos']);
Route::post('webservices/pagamentocontas', ['uses'=>'WebhookController@pagamentocontas']);
Route::post('webservices/darf', ['uses'=>'WebhookController@darf']);
Route::post('webservices/darj', ['uses'=>'WebhookController@darj']);
Route::post('webservices/fgts', ['uses'=>'WebhookController@fgts']);
Route::post('webservices/gare', ['uses'=>'WebhookController@gare']);
Route::post('webservices/gps', ['uses'=>'WebhookController@gps']);
Route::post('webservices/transferenciabancaria', ['uses'=>'WebhookController@transferenciabancaria']);
Route::post('webservices/transferenciaclientefitbank', ['uses'=>'WebhookController@transferenciaclientefitbank']);

Route::post('webservices/github', ['uses'=>'WebhookController@github']);
