<?php

use Illuminate\Support\Facades\Route;

use App\Mail\ContatoForm;

// use Illuminate\Support\Facades\Mail;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });

// Route::group(['middleware' => ['auth']], function() {
//     Route::get('user', 'UserController@getAuthenticatedUser');
//     // Route::get('closed', 'DataController@closed');

//     Route::resource('actionlogs','ActionlogController');
// 	Route::resource('addresses','AddressController');
// 	Route::resource('bankaccounts','BankaccountController');
// 	Route::resource('banks','BankController');
// 	Route::resource('clients','ClientController');
// 	Route::resource('detailedaccounts','DetailedaccountController');
// 	Route::resource('detailedindividualaccounts','DetailedindividualaccountController');
// 	Route::resource('documents','DocumentController');
// 	Route::resource('spsinfos','SpsinfoController');
// 	Route::resource('transactionlogs','TransactionlogController');

// 	Route::get('profile','UserController@profile');
// });

/* estaticos */
// Route::get('/', 'HomeController@index');
Route::get('/', function () {
	return view('static.index');
});

Route::get('/produtoseservicos', function () {
	return view('static.produtoseservicos');
});

Route::get('/quemsomos', function () {
	return view('static.quemsomos');
});

Route::get('/contato', function () {
	return view('static.contato');
});

Route::post('/contato', function () {

	$mensagem = 'Mensagem enviada. Por favor aguarde nosso contato.';

	try {
		Mail::send(new ContatoForm());
	} catch (\Exception $e) {
		// Get error here
		// print $e->getMessage();
		// $mensagem = $e->getMessage();
		$mensagem = 'Houve um problema ao enviar a mensagem. Por favor tente mais tarde.';
	}

	return redirect('/')->with('status', $mensagem);

});

Route::get('/faq', function () {
	return view('static.faq');
});


Route::get('/termos-e-condicoes-de-uso-da-conta-de-pagamento', function () {
	return view('static.termo_uso');
});

Route::get('/landing-page', function () {
	return redirect('/main');
});

Route::get('/main', function () {
	return redirect('/main');
});

Route::get('/politica', function () {
	return view('static.politica');
});


/* estaticos */

Auth::routes(['register' => false]);

Route::get('/logout', 'HomeController@logout')->name('logout');

Route::get('/home', 'HomeController@index')->name('home');
// Route::get('/extrato', 'ClientWebController@extrato')->name('extrato');


Route::match(['get', 'post'], '/extrato', ['uses' => 'ClientWebController@extrato'])->name('extrato');

##Gera o extrato em PDF e CSV
Route::match(['get', 'post'], '/extratopdf', ['uses' => 'ExtratoController@extratoPDF'])->name('extratoPDF');
Route::match(['get', 'post'], '/extratocsv', ['uses' => 'ExtratoController@extratoCSV'])->name('extratoCSV');
Route::match(['get', 'post'], '/extratoxls', ['uses' => 'ExtratoController@extratoXLS'])->name('extratoXLS');

Route::get('/usuarios', 'UserWebController@usuarios')->name('usuarios');
Route::post('/usuarios', 'UserWebController@criaUsuario')->name('criar_usuarios');
Route::post('/usuarios/{id}/atualizar', 'UserWebController@atualizaUsuario')->name('atualizar_usuarios');
Route::post('/usuarios/{id}/mudastatus', 'UserWebController@mudaStatusUsuario')->name('status_usuarios');



Route::get('/clientes', 'ClientWebController@clientes')->name('clientes');
Route::get('/clientesbyname','ClientWebController@clientesFiltradosPorNome');
Route::get('/clientes/{id}', 'ClientWebController@verCliente')->name('ver_clientes');
Route::post('/clientes', 'ClientWebController@criaCliente')->name('criar_clientes');
Route::get('/clientes/{id}/editar', 'ClientWebController@editarCliente')->name('editar_clientes');
Route::post('/clientes/{id}/mudastatus', 'ClientWebController@mudaStatusCliente')->name('status_clientes');
Route::post('/clientes/{id}/sincronizacliente', 'ClientWebController@sincronizacliente')->name('sincroniza_clientes');
Route::post('/clientes/{id}/atualizasaldodisponivel', 'ClientWebController@atualizasaldodisponivel')->name('atualizasaldodisponivel');
Route::post('/clientes/{id}/atualizar', 'ClientWebController@update')->name('atualizacliente');
Route::get('/clientes/{id}/informacoes', 'ClientWebController@informacoes')->name('informacoescliente');
Route::post('/clientes/{id}/atualizarDadosMensalidade', 'ClientWebController@atualizarDadosMensalidade')->name('atualizarDadosMensalidade');

Route::prefix('clientes')->group(function () {

	Route::post(
		'{id_cliente}/dautomatico/ativar',
		'ClientWebController@ativarDAutomatico'
	)->name('clientes.dautomatico.ativar');

	Route::post(
		'dautomatico/buscardocumento',
		'ClientWebController@buscarDocumento'
	)->name('clientes.dautomatico.buscardocumento');

	// Rotas D+0
	Route::post(
		'{id_cliente}/d0automatico/{id_multisafe?}/desativar',
		'ClientWebController@desativarD0Automatico'
	)->name('clientes.d0automatico.desativar');

	Route::get(
		'{id_cliente}/d0automatico/{id_multisafe?}',
		'ClientWebController@viewAtivarD0Automatico'
	)->name('clientes.d0automatico.index');

	// Rotas D+1
	Route::get(
		'{id_cliente}/d1automatico/{id_multisafe?}',
		'ClientWebController@viewAtivarD1Automatico'
	)->name('clientes.d1automatico.index');

	Route::post(
		'{id_cliente}/d1automatico/{id_multisafe?}/desativar',
		'ClientWebController@desativarD1Automatico'
	)->name('clientes.d1automatico.desativar');

	Route::post(
		'{id}/editar/nickname',
		'ClientWebController@editarNicknameClient'
	)->name('clientes.editar_nickname');

	Route::post(
		'{id}/editar/{multisafe}/nickname',
		'ClientWebController@editarNicknameMultisafe'
	)->name('clients.multisafe.editar_nickname');
});

// Route::post(
//     '/clientes/{id_cliente}/d0automatico/{id_multisafe?}/ativar',
//     'ClientWebController@ativarD0Automatico'
// )->name('clientes.d0automatico.ativar');

// Route::post(
//     '/clientes/{id_cliente}/0automatico/{id_multisafe?}/desativar',
//     'ClientWebController@desativarD0Automatico'
// )->name('clientes.d0automatico.desativar');

// Route::get(
//     '/clientes/{id_cliente}/d0automatico/{id_multisafe?}',
//     'ClientWebController@viewAtivarD0Automatico',
// )->name('clientes.d0automatico.index');

Route::get('/clientes/{id}/operacoes', 'ClientWebController@operacoesPeloCliente')->name('operacoes_pelos_clientes');
Route::post('/clientes/{id}/operacoes/realizar', 'ClientWebController@operacoesPeloClienteRealizar')->name('operacoes_pelos_clientes_realizar');
Route::match(['get', 'post'], '/clientes/{id}/extrato', ['uses' => 'ClientWebController@operacoesPeloClienteExtrato'])->name('operacoes_pelos_clientes_extrato');

Route::post('/changecnpj', 'ClientWebController@changecnpj')->name('changecnpjactive');
Route::post('/clientes/novaconta', 'ClientWebController@crianovaconta')->name('crianovaconta');
Route::post('/clientes/multiconta/{id}/mudastatus', 'ClientWebController@multicontaMudastatus')->name('multicontaMudastatus');

/*BOLETOS CRIAR*/
Route::get('/clientes/boletos/avulso', ['uses' => 'ClientWebController@criarBoletoAvulso'])->name('criarBoletoAvulso');
Route::post('/clientes/boletos/contato', ['uses' => 'ClientWebController@criarBoletoContato'])->name('criarBoletoContato');
Route::post('/clientes/boletos/criar', ['uses' => 'ClientWebController@criarBoleto'])->name('criarBoleto');
Route::match(['get', 'post'], '/clientes/boletos/consultar', ['uses' => 'ClientWebController@consultarBoleto'])->name('consultarBoleto');

/*CONTATOS CLIENTE*/
Route::match(['get', 'post'], '/contatos/cliente', ['uses' => 'ClientWebController@contatosCliente'])->name('contatos_clientes');
Route::match(['get', 'post'], '/contatos/cliente/criar', ['uses' => 'ClientWebController@contatosClienteCriar'])->name('contatos_clientes_criar');


/*TRANSFERENCIAS*/
Route::post('/transferencias/contato', 'ClientWebController@transferenciabancariacontato')->name('realizatransferenciabancariacontato');
Route::match(['get', 'post'], '/transferencias/consulta', ['uses' => 'ClientWebController@consultatransferenciabancaria'])->name('consultatransferenciabancaria');

Route::get('/transferencias/agendamentos', 'ClientWebController@agendamentos')->name('transferencias.agendamento.consultar');
Route::post('/transferencias/agendamentos/cancelar', 'ClientWebController@cancelarAgendamento')->name('transferencias.agendamento.cancelar');

/*PAGAMENTOS BOLETOS*/
// Route::match(['get', 'post'],'/pagamentos/boletos', ['uses'=>'BarcodepaymentController@pagamentoboleto'])->name('pagamentoboleto');
// Route::post('/pagamentos/boletos/pagar', 'BarcodepaymentController@pagamentoboletopagar')->name('pagamentoboletopagar');
// Route::match(['get', 'post'],'/pagamentos/consultar', ['uses'=>'BarcodepaymentController@logpagamentos'])->name('logpagamentos');

/*DARF*/
// Route::get('/darf', 'DarfpaymentController@darfFormulario')->name('darfformulario');
// Route::post('/darf/enviar', 'DarfpaymentController@darfEnviar')->name('darfenviar');
// Route::match(['get', 'post'],'/darf/consultar', ['uses'=>'DarfpaymentController@darfConsultar'])->name('darfconsultar');
/*DARJ*/
// Route::get('/darj', 'DarjpaymentController@darjFormulario')->name('darjformulario');
// Route::post('/darj/enviar', 'DarjpaymentController@darjEnviar')->name('darjenviar');
// Route::match(['get', 'post'],'/darj/consultar', ['uses'=>'DarjpaymentController@darjConsultar'])->name('darjconsultar');
/*FGTS*/
// Route::get('/fgts', 'FgtspaymentController@fgtsFormulario')->name('fgtsformulario');
// Route::post('/fgts/enviar', 'FgtspaymentController@fgtsEnviar')->name('fgtsenviar');
// Route::match(['get', 'post'],'/fgts/consultar', ['uses'=>'FgtspaymentController@fgtsConsultar'])->name('fgtsconsultar');
/*GPS*/
// Route::get('/gps', 'GpspaymentController@gpsFormulario')->name('gpsformulario');
// Route::post('/gps/enviar', 'GpspaymentController@gpsEnviar')->name('gpsenviar');
// Route::match(['get', 'post'],'/gps/consultar', ['uses'=>'GpspaymentController@gpsConsultar'])->name('gpsconsultar');
/*GaRE*/
// Route::get('/gare', 'GarepaymentController@gareFormulario')->name('gareformulario');
// Route::post('/gare/enviar', 'GarepaymentController@gareEnviar')->name('gareenviar');
// Route::match(['get', 'post'],'/gare/consultar', ['uses'=>'GarepaymentController@gareConsultar'])->name('gareconsultar');

// Route::get('/pagamentos-agendados', 'ClientWebController@pagamentosAgendados')->name('gareformulario');


/* PERFIL */
Route::get('/usuario/mudarsenha', 'UserWebController@mudarsenha')->name('usuariocliente_mudasenha');
Route::post('/usuario/mudarsenha/trocar', 'UserWebController@atualizarsenha')->name('usuariocliente_trocar');


Route::post('/usuario/enviarlinkreset', 'UserWebController@sendResetPasswordLink')->name('sendResetPasswordLink');

Route::get('/enviaclientefitbank/{id}', 'ClientWebController@enviaclientefitbank')->name('enviaclientefitbank');
Route::get('/enviaclientemultifitbank/{cnpj}', 'ClientWebController@enviaclientemultifitbank')->name('enviaclientemultifitbank');


/* EXPORT */
Route::post('/exporta/xls', 'SpsinfoController@exportXLS')->name('exportXLS');


/* ADMIN */
Route::post('/clientes/detalhes', 'ClientWebController@getClientDetails')->name('clientes.detalhes');

Route::get('/transferenciacliente', 'ClientWebController@transferenciacliente')->name('transferenciacliente');
Route::get('/transferencia-cliente', 'ClientWebController@transferenciaSimplesCliente')->name('transferencia.cliente'); ///
Route::get('/transferenciasps', 'SpsinfoController@transferenciasps')->name('transferenciasps');

Route::post('/transferenciacliente', 'ClientWebController@realizaTransferenciaCliente')->name('realizaTransferenciaCliente');
Route::get('/telatransferenciarealizada', 'ClientWebController@transferenciaClienteRealizada')->name('transferenciaRealizada');

Route::post('/transferenciaclienterapida', 'ClientWebController@realizaTransferenciaClienteRapida')->name('realizaTransferenciaClienteRapida');

Route::post('/transferenciasps', 'SpsinfoController@realizatransferenciasps')->name('realizatransferenciasps');
Route::match(['get', 'post'], '/transferenciarapida', ['uses' => 'SpsinfoController@transferenciarapida'])->name('transferenciarapida');
Route::match(['get', 'post'], '/transferencia-visao-geral', ['uses' => 'SpsinfoController@transferenciaVisaoGeral'])->name('transferenciaVisaoGeral');

Route::get('/transferenciainterna', 'ClientWebController@transferenciainterna')->name('transferenciainterna');
Route::post('/transferenciainterna', 'ClientWebController@realizaTransferenciaInterna')->name('realizaTransferenciaInterna');

// Route::get('/logtransferencias', 'SpsinfoController@logtransferencias')->name('logtransferencias');

Route::match(['get', 'post'], '/logs/pagamentos', 'SpsinfoController@erropagamentos')->name('erropagamentos');
Route::match(['get', 'post'], '/logs/boletos', 'SpsinfoController@erroboletos')->name('erroboletos');
Route::match(['get', 'post'], '/logs/transferencias', 'SpsinfoController@errotransferencias')->name('errotransferencias');
Route::match(['get', 'post'], '/logs/transacoesfit', 'LogController@transacoesfit')->name('transacoesfit');

Route::match(['get', 'post'], '/logs/saldodisponivel', 'SpsinfoController@logsaldodisponivel')->name('logsaldodisponivel');

Route::match(['get', 'post'], '/logtransferencias', ['uses' => 'SpsinfoController@logtransferencias'])->name('logtransferencias');



Route::get('/consultatransferenciascliente', 'ClientWebController@consultaTransferenciasCliente')->name('consultaTransferenciasCliente');

Route::get('/spsinfo', 'SpsinfoController@index')->name('spsinfo_index');
Route::get('/spsinfo/{id}', 'SpsinfoController@editspsinfo')->name('spsinfo_edit');
Route::post('/spsinfo', 'SpsinfoController@update')->name('update_spsinfo');
Route::match(['get', 'post'], '/extratosps', ['uses' => 'SpsinfoController@extrato'])->name('extratosps');
Route::post('/spsbanks', 'SpsinfoController@spsbanks')->name('spsbanks');
Route::post('/spsbanks/remove', 'SpsinfoController@spsbanksRemove')->name('spsbanksRemove');
Route::match(['get', 'post'], '/ferramentas', 'SpsinfoController@ferramentas')->name('spsinfo_ferramentas');
Route::match(['get', 'post'], '/provisionamento', 'SpsinfoController@provisionamento')->name('provisionamento');

Route::match(['get', 'post'], '/mensalidades/ver', ['uses' => 'MonthlyFeePaymentController@ver'])->name('ver_mensalidades');
Route::post('/mensalidades/editar', ['uses' => 'MonthlyFeePaymentController@editar'])->name('editar_mensalidades');

Route::match(['get', 'post'], '/relatorios/tarifas/simples', 'SpsinfoController@relatoriosTarifasSimples')->name('relatoriosTarifasSimples');
Route::match(['get', 'post'], '/relatorios/tarifas/detalhado', 'SpsinfoController@relatoriosTarifasDetalhado')->name('relatoriosTarifasDetalhado');
Route::match(['get', 'post'], '/relatorios/tarifas/graficos', 'SpsinfoController@relatoriosTarifasGraficos')->name('relatoriosTarifasGrafico');
Route::match(['get', 'post'], '/relatorios/tarifas/comparativos', 'SpsinfoController@relatoriosTarifasComparativos')->name('relatoriosTarifasComparativos');
Route::match(['get', 'post'], '/relatorios/tarifas/anual', 'SpsinfoController@relatoriosTarifasAnual')->name('relatoriosTarifasAnual');

/* MUDDLEWARE ACL */
Route::group(['middleware' => 'access.control.list'], function () {

	/* TESTES */
	Route::match (['get', 'post'], '/testes/listar', 'TesteController@testes')->name('testes.listar');

	/* TRANSFERÊNCIAS */
	Route::match (['get', 'post'], '/transferencias/bancaria/inclusao', 'ClientWebController@transferenciabancariaincluir')
		->name('transferencia.bancaria.gerenciar.incluir.info');
	Route::post('/transferencias/bancaria/realizarinclusao', 'ClientWebController@transferenciabancariarealizarinclusao')
		->name('transferencia.bancaria.gerenciar.incluir');
	Route::match (['get', 'post'], '/transferencias/bancaria/consultar', ['uses' => 'ClientWebController@consultatransferenciabancaria'])
		->name('transferencia.bancaria.gerenciar.consultar');
	Route::get('/transferencias/bancaria/autorizar', 'ClientWebController@transferenciabancariaautorizarconsulta')
		->name('transferencia.bancaria.gerenciar.autorizar.consulta');
	Route::post('/transferencias/bancaria/autorizar', 'ClientWebController@transferenciabancariaautorizar')
		->name('transferencia.bancaria.gerenciar.autorizar');
	Route::get('/transferencias', 'ClientWebController@transferenciabancaria')
		//->name('transferenciabancaria');
		->name('transferencia.bancaria.gerenciar.transferir.info');
	Route::post('/realizatransferenciabancaria', 'ClientWebController@realizatransferenciabancaria')
		//->name('realizatransferenciabancaria');
		->name('transferencia.bancaria.gerenciar.transferir');

});

/* TESTES */
Route::match(['get', 'post'], '/testes/clientesps', 'TesteController@testesClienteSPS')->name('testes.metodosclientesps');
Route::match(['get', 'post'], '/testes/testedd', 'TesteController@testesDD')->name('testes.dd');

// Route::match(['get', 'post'],'/testes/mensalidades/{listarTodos?}', 'TesteController@testeMensalidades')->name('testes.mensalidades');
// Route::match(['get', 'post'],'/testes/lancar-mensalidades', 'TesteController@lancarMensalidades')->name('testes.lancarmensalidades');
// Route::match(['get', 'post'],'/testes/pagar-mensalidades', 'TesteController@pagarMensalidades')->name('testes.pagarmensalidades');
Route::match(['get'], '/testes/buscar-saldo-cliente', 'TesteController@buscarSaldoCliente')->name('testes.mensalidades.buscarsaldocliente');


// Rotas criadas para testes do ticket Saldo Devedor + Mensalidahttps://meet.google.com/wbg-nmvf-utcdes (Pagamento Unificado)
Route::match(['get', 'post'], '/testes/pagamento-unificado', 'TesteController@exibirViewPagamentoUnificado')->name('testes.pagamento-unificado');

Route::match(['get', 'post'], '/testes/mensalidades/lancar', 'TesteController@lancarTesteMensalidades')->name('testes.mensalidades.lancar');
Route::match(['get', 'post'], '/testes/mensalidades/pagar', 'TesteController@pagarTesteMensalidades')->name('testes.mensalidades.pagar');


Route::match(['get', 'post'], '/testes/distribuicoes/lancar', 'TesteController@lancarDistribuicoes')->name('testes.distribuicoes.lancar');

Route::match(['get', 'post'], '/testes/limitesutilizados/pagar', 'TesteController@pagarLimitesUtilizados')->name('testes.limites-utilizados.pagar');
Route::match(['get', 'post'], '/testes/limitesutilizados/calculartaxas', 'TesteController@calcularTaxasLimitesUtilizados')->name('testes.limites-utilizados.calcular-taxas');
Route::match(['get', 'post'], '/testes/limitesutilizados/cobrartaxas', 'TesteController@cobrarTaxasLimitesUtilizados')->name('testes.limites-utilizados.cobrar-taxas');

Route::match(['get', 'post'], '/testes/distribuicao/efetuar', 'TesteController@distribuirValores')->name('testes.distribuicao.efetuar');

Route::match(['get', 'post'], '/testes/d0automatico', 'TesteController@exibirViewD0Automatico')->name('testes.d0automatico');
Route::match(['get', 'post'], '/testes/d0automatico/agendar', 'TesteController@agendarD0')->name('testes.d0automatico.agendar');
Route::post('/testes/d0automatico/desabilitarCliente/{id}', 'TesteController@desabilitarD0Cliente')->name('testes.d0automatico.desabilitar-cliente');
Route::post('/testes/d0automatico/autorizar', 'TesteController@autorizarD0')->name('testes.d0automatico.autorizar');
Route::post('/testes/d0automatico/cancelar/{id}', 'TesteController@cancelarD0')->name('testes.d0automatico.cancelar');
Route::post('/testes/d0automatico/desfazerCancelamento/{id}', 'TesteController@desfazerCancelamentoD0')->name('testes.d0automatico.desfazer-cancelamento');

Route::post('/testes/d1automatico/desabilitarCliente/{id}', 'TesteController@desabilitarD1Cliente')->name('testes.d1automatico.desabilitar-cliente');
