<?php $__env->startSection('extrajs'); ?>
    <script src="<?php echo e(asset('js/jquery.maskMoney.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.mask.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row justify-content-md-center">
        <div class="col-md-8 col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"> <?php echo e($client->nickname); ?></h4>
                    <?php if(empty($client->businessunitid)): ?>
                        <a href="<?php echo e(url('/enviaclientefitbank/'.$client->id)); ?>"><button class="btn btn-sm btn-info">Enviar para Fitbank</button></a>
                    <?php endif; ?>
                    <a href="#" data-toggle="modal" data-target="#editclient-<?php echo e($client->id); ?>">
                        <button type="button" class="btn btn-outline-info btn-sm" style="float:right">Editar</button>
                    </a>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <p class="text-danger">Os dados dos clientes devem ser alterados no Fitbank Web e depois atualizados aqui.</p>
                        </div>
                    </div>

                    <div class="mt-1 text-right">
                        <a href="#" onclick="submitForm()">
                            <i class="feather icon-refresh-ccw text-info"></i>
                        </a>
                        &nbsp;&nbsp;
                        <a href="#" data-toggle="modal" data-target="#status-<?php echo e($client->id); ?>">
                            <i class="feather <?php echo e(($client->active==0)?'icon-check-circle text-success':'icon-x-circle text-danger'); ?>"></i>
                        </a>
                    </div>

                    <div class="row">
                        <div class="col-md-6 col-sm-12">

                            <h2>SSG</h2>

                            <div class="mt-1">
                                <h6 class="mb-0">Razão social</h6>
                                <p><?php echo e($client->name); ?></p>
                            </div>
                            <div class="mt-1">
                                <h6 class="mb-0">CNPJ/CPF</h6>
                                <p><?php echo e(formataCNPJ($client->taxnumber)); ?></p>
                            </div>
                            <div class="mt-1">
                                <h6 class="mb-0">Id interno Fitbank</h6>
                                <p><?php echo e($client->businessunitid); ?></p>
                            </div>
                            <div class="mt-1">
                                <h6 class="mb-0">Email</h6>
                                <p><?php echo e($client->mail); ?></p>
                            </div>
                            <div class="mt-1">
                                <h6 class="mb-0">Telefone</h6>
                                <p><?php echo e($client->phone); ?></p>
                            </div>
                        </div>

                        <div class="col-md-6 col-sm-12">

                            <h2>Fitbank</h2>

                            <?php if(!$clientfitbank): ?>
                                <p>Cliente não existe no Fitbank ou não foi possível consultar.</p>
                            <?php else: ?>
                                <div class="mt-1">
                                    <h6 class="mb-0">Razão social</h6>
                                    <p><?php echo e($clientfitbank['AccountData']['TradingName']); ?></p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">CNPJ/CPF</h6>
                                    <p><?php echo e(formataCNPJ($clientfitbank['AccountData']['TaxNumber'])); ?></p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Id interno Fitbank</h6>
                                    <p><?php echo e($clientfitbank['AccountData']['Identifier']); ?></p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Email</h6>
                                    <p><?php echo e($clientfitbank['AccountData']['Mail']); ?></p>
                                </div>
                                <div class="mt-1">
                                    <h6 class="mb-0">Telefone</h6>
                                    <p><?php echo e($clientfitbank['AccountData']['Phone']); ?></p>
                                </div>

                               <form action="<?php echo e(url('/clientes/'.$client->id.'/sincronizacliente')); ?>" method="POST" id="sincronizasps">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="id" value="<?php echo e($client->id); ?>">
                                    <input type="hidden" name="name" value="<?php echo e($clientfitbank['AccountData']['TradingName']); ?>">
                                    <input type="hidden" name="taxnumber" value="<?php echo e($clientfitbank['AccountData']['TaxNumber']); ?>">
                                    <input type="hidden" name="businessunitid" value="<?php echo e($clientfitbank['AccountData']['Identifier']); ?>">
                                    <input type="hidden" name="mail" value="<?php echo e($clientfitbank['AccountData']['Mail']); ?>">
                                    <input type="hidden" name="phone" value="<?php echo e($clientfitbank['AccountData']['Phone']); ?>">
                                </form>

                            <?php endif; ?>
                        </div>

                        <div class="col-md-12 mt-1">
                            <div class="row">
                                <h6 class="mb-0 col-md-3">D+0 Automático:
                                    <?php if( $client->d0automatic == 1): ?>
                                        <span class="text-success">Ativado</span>
                                    <?php else: ?>
                                        <span class="text-muted">Desativado</span>
                                    <?php endif; ?>
                                </h6>
                                <?php if( $client->d0automatic == 1): ?>
                                    <button type="button" class="btn btn-outline-danger btn-sm" data-toggle="modal" data-target="#modaldesativard0cliente">Desativar</button>
                                <?php else: ?>
                                    <a href="<?php echo e(route('clientes.d0automatico.index', [
                                        'id_cliente' => $client->id,
                                        'id_multisafe' => 0
                                    ])); ?>" class="btn btn-outline-success btn-sm">Ativar</a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-12 mt-1">
                            <div class="row">
                                <h6 class="mb-0 col-md-3">D+1 Automático:
                                    <?php if( $client->d1automatic == 1): ?>
                                        <span class="text-success">Ativado</span>
                                    <?php else: ?>
                                        <span class="text-muted">Desativado</span>
                                    <?php endif; ?>
                                </h6>
                                <?php if( $client->d1automatic == 1): ?>
                                    <button type="button" class="btn btn-outline-danger btn-sm" data-toggle="modal" data-target="#modaldesativard1cliente">Desativar</button>
                                <?php else: ?>
                                    <a href="<?php echo e(route('clientes.d1automatico.index', [
                                        'id_cliente' => $client->id,
                                        'id_multisafe' => 0,
                                    ])); ?>" class="btn btn-outline-success btn-sm">Ativar</a>
                                <?php endif; ?>
                            </div>
                        </div>

                    </div>


                    <br><br>

                    <div class="row">
                        <div class="col-12">

                            <div class="divider divider-info">
                                <div class="divider-text">Informações bancárias</div>
                            </div>

                            <br><br>

                            <div class="mt-1">
                                <h6 class="mb-0">Banco</h6>
                                <p><?php echo e($client->banknumber); ?></p>
                            </div>
                            <div class="mt-1">
                                <h6 class="mb-0">Agência</h6>
                                <p><?php echo e(formataCNPJ($client->bankbranch)); ?></p>
                            </div>
                            <div class="mt-1">
                                <h6 class="mb-0">Conta</h6>
                                <p><?php echo e($client->bankaccount); ?></p>
                            </div>
                            <div class="mt-1">
                                <h6 class="mb-0">Permitir limite especial</h6>
                                <p><?php echo e(($client->availablelimit==1)?'Sim':'Não'); ?></p>
                            </div>

                            <div class="mt-1">
                                <h6 class="mb-0">Saldo disponível</h6>
                                <p>R$ <?php echo e(formatMoneyBr($client->availablelimit)); ?></p>
                            </div>

                            <div class="mt-1">
                                <h6 class="mb-0">Alterar saldo disponível</h6>
                                <form action="<?php echo e(url('/clientes/'.$client->id.'/atualizasaldodisponivel')); ?>" method="POST" class="form form-horizontal">
                                    <?php echo csrf_field(); ?>
                                    <div class="form-body">
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                                            <input type="hidden" name="taxnumber" value="<?php echo e($client->taxnumber); ?>">
                                            <input type="text" id="valor" class="form-control valor" name="valor" value="<?php echo e(formatMoneyBr($client->availablelimit)); ?>">
                                        </div>
                                        <div class="col-md-3">
                                            <button type="submit" class="btn btn-primary btn-block" value="Atualizar">Atualizar saldo</button>
                                        </div>
                                    </div>
                                    </div>
                                </form>
                            </div>

                            <br>
                            <div class="divider divider-info">
                                <div class="divider-text"><h4>Contas adicionais</h4></div>
                            </div>

                            <div class="row justify-content-md-center text-right separator-b-10">
                                <div class="col-md-8 col-12 text-right">
                                    <button type="button" class="btn btn-md btn-icon btn-success waves-effect waves-light" data-toggle="modal" data-target="#inlineForm"><i class="feather icon-plus"></i> Adicionar conta/CNPJ</button>
                                </div>
                            </div>

                            <?php $multicnpj = getMultiCnpj($client->id);?>

                            <?php if($multicnpj->count() > 0): ?>

                                <?php $__currentLoopData = $multicnpj; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $multi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <div class="row">

                                        <?php if($multi->active == 1): ?>
                                            <div class="col-md-12 mt-1">
                                                <h4><?php echo e(formataCNPJ($multi->taxnumber)); ?>

                                                    <a href="#" data-toggle="modal" data-target="#statusmulti-<?php echo e($multi->id); ?>">
                                                        <button type="button" class="btn btn-outline-danger btn-sm" style="margin-left:25px;">Desativar</button>
                                                    </a>
                                                    <?php if($multi->businessunitid < 1): ?>
                                                        <a href="<?php echo e(url('/enviaclientemultifitbank/'.$multi->id)); ?>"><button class="btn btn-sm btn-info">Enviar para Fitbank</button></a>
                                                    <?php endif; ?>
                                                    <a href="#" data-toggle="modal" data-target="#editmulti-<?php echo e($multi->id); ?>">
                                                        <button type="button" class="btn btn-outline-info btn-sm" style="float:right">Editar</button>
                                                    </a>
                                                </h4>
                                            </div>

                                            <div class="col-md-12">
                                                <h5><?php echo e($multi->nickname); ?></h5>
                                            </div>

                                            <div class="col-md-12 mt-1">
                                                <h6 class="mb-0">Saldo disponível</h6>
                                                <p>R$ <?php echo e(formatMoneyBr($multi->availablelimit)); ?></p>
                                            </div>

                                            <div class="col-md-12 mt-1">
                                                <h6 class="mb-0">Alterar saldo disponível</h6>
                                                <form action="<?php echo e(url('/clientes/'.$client->id.'/atualizasaldodisponivel')); ?>" method="POST" class="form form-horizontal">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="form-body">
                                                    <div class="form-group row">
                                                        <div class="col-md-4">
                                                            <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                                                            <input type="hidden" name="taxnumber" value="<?php echo e($multi->taxnumber); ?>">
                                                            <input type="text" id="valor" class="form-control valor" name="valor" value="<?php echo e(formatMoneyBr($multi->availablelimit)); ?>">
                                                        </div>
                                                        <div class="col-md-3">
                                                            <button type="submit" class="btn btn-primary btn-block" value="Atualizar">Atualizar saldo</button>
                                                        </div>
                                                    </div>
                                                    </div>
                                                </form>
                                            </div>

                                            <div class="col-md-12 mt-1">
                                                <h6 class="mb-0">Alterar valor da mensalidade</h6>
                                                <form action="<?php echo e(url('/clientes/'.$client->id.'/atualizarDadosMensalidade')); ?>" method="POST" class="form form-horizontal">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="form-body">
                                                    <div class="form-group row">
                                                        <div class="col-md-4">
                                                            <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                                                            <input type="hidden" name="taxnumber" value="<?php echo e($multi->taxnumber); ?>">
                                                            <input type="text" id="valor" class="form-control valor" name="valor" value="<?php echo e(formatMoneyBr($multi->monthlyfee)); ?>">
                                                        </div>
                                                        <div class="col-md-3">
                                                            <button type="submit" class="btn btn-primary btn-block" value="Atualizar">Atualizar valor</button>
                                                        </div>
                                                    </div>
                                                    </div>
                                                </form>
                                            </div>

                                            <div class="col-md-12 mt-1">
                                                <h6 class="mb-0">Alterar dia de pagamento da mensalidade</h6>
                                                <form action="<?php echo e(url('/clientes/'.$client->id.'/atualizarDadosMensalidade')); ?>" method="POST" class="form form-horizontal">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="form-body">
                                                    <div class="form-group row">
                                                        <div class="col-md-4">
                                                            <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                                                            <input type="hidden" name="taxnumber" value="<?php echo e($multi->taxnumber); ?>">
                                                            <select name="monthlyfeedueday" class="form-control">
                                                                <?php for($i=1;$i<29;$i++): ?>
                                                                    <option value="<?php echo e($i); ?>" <?php echo e(($multi->monthlyfeedueday == $i) ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                                                <?php endfor; ?>
                                                            </select>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <button type="submit" class="btn btn-primary btn-block" value="Atualizar">Atualizar dia</button>
                                                        </div>
                                                    </div>
                                                    </div>
                                                </form>
                                            </div>

                                            <div class="col-md-12 mt-1">
                                                <div class="row">
                                                    <h6 class="mb-0 col-md-3">D+0 Automático:
                                                        <?php if( $multi->d0automatic == 1): ?>
                                                            <span class="text-success">Ativado</span>
                                                        <?php else: ?>
                                                            <span class="text-muted">Desativado</span>
                                                        <?php endif; ?>
                                                    </h6>
                                                    <?php if( $multi->d0automatic == 1): ?>
                                                        <a class="col-md-2" href="#" data-target="#statusd0-<?php echo e($multi->id); ?>" data-toggle="modal">
                                                    <?php else: ?>
                                                        <a class="col-md-2" href="<?php echo e(route('clientes.d0automatico.index', [
                                                                    'id_cliente' => $client->id,
                                                                    'id_multisafe' => $multi->id
                                                                ])); ?>"
                                                        >
                                                    <?php endif; ?>
                                                        <?php if( $multi->d0automatic == 1): ?>
                                                            <button type="button" class="btn btn-outline-danger btn-sm">Desativar</button>
                                                        <?php else: ?>
                                                            <button type="button" class="btn btn-outline-success btn-sm">Ativar</button>
                                                        <?php endif; ?>
                                                    </a>
                                                </div>
                                            </div>

                                            <div class="col-md-12 mt-1">
                                                <div class="row">
                                                    <h6 class="mb-0 col-md-3">D+1 Automático:
                                                        <?php if( $multi->d1automatic == 1): ?>
                                                            <span class="text-success">Ativado</span>
                                                        <?php else: ?>
                                                            <span class="text-muted">Desativado</span>
                                                        <?php endif; ?>
                                                    </h6>
                                                    <?php if( $multi->d1automatic == 1): ?>
                                                        <a class="col-md-2" href="#" data-target="#statusd1-<?php echo e($multi->id); ?>" data-toggle="modal">
                                                    <?php else: ?>
                                                        <a class="col-md-2" href="<?php echo e(route('clientes.d1automatico.index', [
                                                                    'id_cliente' => $client->id,
                                                                    'id_multisafe' => $multi->id,
                                                                ])); ?>"
                                                        >
                                                    <?php endif; ?>
                                                        <?php if( $multi->d1automatic == 1): ?>
                                                            <button type="button" class="btn btn-outline-danger btn-sm">Desativar</button>
                                                        <?php else: ?>
                                                            <button type="button" class="btn btn-outline-success btn-sm">Ativar</button>
                                                        <?php endif; ?>
                                                    </a>
                                                </div>
                                            </div>

                                        <?php else: ?>

                                            <div class="col-md-12 mt-1">
                                                <p class="text-muted font-medium-3"><?php echo e(formataCNPJ($multi->taxnumber)); ?>

                                                    <a href="#" data-toggle="modal" data-target="#statusmulti-<?php echo e($multi->id); ?>">
                                                        <button type="button" class="btn btn-outline-success btn-sm" style="margin-left:25px;">Ativar</button>
                                                    </a>
                                                </p>
                                            </div>

                                            <div class="col-md-12">
                                                <h5 class="text-muted"><?php echo e($multi->nickname); ?></h5>
                                            </div>

                                        <?php endif; ?>

                                        
                                        <div class="modal fade text-left" id="editmulti-<?php echo e($multi->id); ?>" tabindex="-1" role="dialog" aria-labelledby="Editar Cliente" style="display: none;" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="editmulti">Cliente <?php echo e(formataCNPJ($multi->taxnumber)); ?></h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">×</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('clients.multisafe.editar_nickname', [
                                                        'id' => $client->id,
                                                        'multisafe' => $multi->id
                                                    ])); ?>" method="POST">
                                                        <input type="hidden" name="maintaxnumber" value="<?php echo e($client->taxnumber); ?>">
                                                        <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                                                        <input type="hidden" name="multisafe_id" value="<?php echo e($multi->id); ?>">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">
                                                            <label>Nome Atual: <?php echo e($multi->nickname); ?></label><br/>
                                                            <label>Novo Nome</label>
                                                            <div class="form-group">
                                                                <input type="text" name="nickname" placeholder="Insira o novo nome" value="<?php echo e($multi->nickname); ?>" class="form-control">
                                                                <span class="text-muted">A acentuação será removida automaticamente ao salvar</span>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                                            <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div> 
                                        

                                        
                                        <div class="modal fade text-left" id="statusmulti-<?php echo e($multi->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="myModalLabel33"><?php echo e(($multi->active==1)?'Desativar':'Ativar'); ?> <?php echo e(formataCNPJ($multi->taxnumber)); ?>?</h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">×</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(url('/clientes/multiconta/'.$multi->id.'/mudastatus')); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">
                                                            <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                                            <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(($multi->active==1)?'Desativar':'Ativar'); ?></button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div> 
                                        

                                        
                                        <div class="modal fade" id="statusd0-<?php echo e($multi->id); ?>" tabindex="-2" role="dialog" aria-labelledby="modald0-<?php echo e($multi->id); ?>" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modald0-<?php echo e($multi->id); ?>">
                                                                Desativar D+0 Automático para <?php echo e(formataCNPJ($multi->taxnumber)); ?>?
                                                        </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">×</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('clientes.d0automatico.desativar', [
                                                        'id_cliente' => $client->id,
                                                        'id_multisafe' => $multi->id
                                                    ])); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">
                                                            <input type="hidden" name="id" value="<?php echo e($multi->id); ?>">
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-outline-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                                            <button type="submit" class="btn btn-danger waves-effect waves-light">
                                                                Desativar
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div> 
                                        

                                        
                                        <div class="modal fade text-left" id="statusd1-<?php echo e($multi->id); ?>" tabindex="-3" role="dialog" aria-labelledby="modald1-<?php echo e($multi->id); ?>" style="display: none;" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modald+0-<?php echo e($multi->id); ?>">
                                                            <?php echo e(($multi->active==1) ? 'Desativar' : 'Ativar'); ?> D+1 para <?php echo e(formataCNPJ($multi->taxnumber)); ?> ?
                                                        </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">×</span>
                                                        </button>
                                                    </div>
                                                    <form action="<?php echo e(route('clientes.d1automatico.desativar', [
                                                        'id_cliente' => $client->id,
                                                        'id_multisafe' => $multi->id
                                                    ])); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="modal-body">
                                                             <input type="hidden" name="id" value="<?php echo e($multi->id); ?>">
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-outline-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                                            <button type="submit" class="btn btn-danger waves-effect waves-light">
                                                                Desativar
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div> 
                                        

                                    </div> 

                                    <?php if($k < $multicnpj->count() - 1): ?>
                                        <hr class="my-4"/>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <?php endif; ?>

                        </div>
                    </div>

                    <br><br>

                    <div class="row">
                        <div class="col-12">
                            <form action="<?php echo e(url('clientes/'.$client->id.'/atualizar')); ?>" method="POST">
                                <?php echo csrf_field(); ?>

                                <input type="hidden" name="id" value="<?php echo e($client->id); ?>">
                                <div class="divider divider-info">
                                    <div class="divider-text">Taxas</div>
                                </div>

                                <br><br>

                                <div class="col-12">
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <span>Taxas diferenciadas</span>
                                        </div>
                                        <div class="col-md-4">
                                            <select name="customrates" class="form-control">
                                        <option value="1" <?php echo e(($client->customrates==1)?'selected':''); ?>>Sim</option>
                                        <option value="0" <?php echo e(($client->customrates==0)?'selected':''); ?>>Não</option>
                                    </select>
                                        </div>
                                    </div>
                                </div>

                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <th>Transação</th>
                                        <th class="text-center">Custo</th>
                                        <th class="text-center">Tipo</th>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th scope="row">Pagamentos</th>
                                            <td class="text-center"><input type="text" id="payments" class="form-control input-align-right" name="payments" value="<?php echo e(formatMoneyBr($client->payments)); ?>"></td>
                                            <td class="text-center">
                                                <select name="paymentspercentage" class="form-control">
                                                    <option value="1" <?php echo e(($client->paymentspercentage=='1')?'selected':''); ?>>Percentual</option>
                                                    <option value="0" <?php echo e(($client->paymentspercentage=='0')?'selected':''); ?>>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Transferências (DOC/TED)</th>
                                            <td class="text-center"><input type="text" id="transfers" class="form-control input-align-right" name="transfers" value="<?php echo e(formatMoneyBr($client->transfers)); ?>"></td>
                                            <td class="text-center">
                                                <select name="transferspercentage" class="form-control">
                                                    <option value="1" <?php echo e(($client->transferspercentage=='1')?'selected':''); ?>>Percentual</option>
                                                    <option value="0" <?php echo e(($client->transferspercentage=='0')?'selected':''); ?>>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Geração de boletos</th>
                                            <td class="text-center"><input type="text" id="billets" class="form-control input-align-right" name="billets" value="<?php echo e(formatMoneyBr($client->billets)); ?>"></td>
                                            <td class="text-center">
                                                <select name="billetspercentage" class="form-control">
                                                    <option value="1" <?php echo e(($client->billetspercentage=='1')?'selected':''); ?>>Percentual</option>
                                                    <option value="0" <?php echo e(($client->billetspercentage=='0')?'selected':''); ?>>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th scope="row">Adiantamento de saldo</th>
                                            <td class="text-center"><input type="text" id="balanceusage" class="form-control input-align-right" name="balanceusage" value="<?php echo e(formatMoneyBr($client->balanceusage)); ?>"></td>
                                            <td class="text-center">
                                                <select name="balanceusagepercentage" class="form-control">
                                                    <option value="1" <?php echo e(($client->balanceusagepercentage=='1')?'selected':''); ?>>Percentual</option>
                                                    <option value="0" <?php echo e(($client->balanceusagepercentage=='0')?'selected':''); ?>>Valor fixo</option>
                                                </select>
                                            </td>
                                        </tr><tr>
                                            <th scope="row">Tarifa mensal</th>
                                            <td class="text-center"><input type="text" id="monthlyfee" class="form-control input-align-right" name="monthlyfee" value="<?php echo e(formatMoneyBr($client->monthlyfee)); ?>"></td>
                                            <td class="text-center">
                                                Valor fixo
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>

                                <br><br>

                                <div class="col-12">
                                    <div class="form-group row">
                                        <div class="col-md-4">
                                            <span>Dia do vencimento tarifa</span>
                                        </div>
                                        <div class="col-md-2">
                                            <select name="monthlyfeedueday" class="form-control">
                                                <?php for($i=1;$i<29;$i++): ?>
                                                    <option value="<?php echo e($i); ?>" <?php echo e(($client->monthlyfeedueday == $i)?'selected':''); ?>><?php echo e($i); ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <hr>
                                <br>
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light" data-toggle="modal" data-target="#editainfo">Salvar alterações</button>
                                </div>

                            </form>
                        </div>
                    </div>

                    <br><br>

                    <div class="divider divider-info">
                        <div class="divider-text">Usuário(s) do cliente com acesso ao sistema</div>
                    </div>
                    <div class="mt-1 text-right">
                        <button type="button" class="btn btn-md btn-icon btn-success waves-effect waves-light" data-toggle="modal" data-target="#cliente_usuario_<?php echo e($client->id); ?>"><i class="feather icon-user-plus"></i></button>
                    </div>

                    <?php $usuarios = usuariosCliente($client->id); ?>
                    <br>
                    <div class="row">
                        <table class="table table-bordered table-striped">
                            <tbody>
                            <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="<?php echo e(($usr->active==0)?'text-muted':''); ?>">
                                    <th class="text-nowrap" scope="row"><?php echo e($usr->name); ?></th>
                                    <td><?php echo e($usr->email); ?></td>
                                    <td><a href="#" data-toggle="modal" data-target="#edita_<?php echo e($usr->id); ?>"><i class="feather icon-edit text-primary"></i></a></td>
                                    <td><a href="#" onclick="return sendResetLink(<?php echo e($usr->id); ?>)" title="Resetar senha"><i class="feather icon-lock text-info"></i></a></td>
                                    <td>
                                        <a href="#" data-toggle="modal" data-target="#status-<?php echo e($usr->id); ?>">
                                            <i class="feather <?php echo e(($usr->active==0)?'icon-user-check text-success':'icon-user-x text-danger'); ?>"></i>
                                        </a>
                                    </td>
                                </tr>

                                <form id="sendresetlink<?php echo e($usr->id); ?>" action="<?php echo e(url('usuario/enviarlinkreset')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="user_id" value="<?php echo e($usr->id); ?>">
                                    <input type="hidden" name="useremail" value="<?php echo e($usr->email); ?>">
                                </form>

                                
                                <div class="modal fade text-left" id="edita_<?php echo e($usr->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="myModalLabel33"><?php echo e($usr->name); ?> - Editar</h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <form action="<?php echo e(url('/usuarios/'.$usr->id.'/atualizar')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">

                                                    <input type="hidden" name="client_id" value="<?php echo e($usr->client_id); ?>">

                                                    <label>Nome: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="name" placeholder="Nome" class="form-control" value="<?php echo e($usr->name); ?>">
                                                    </div>

                                                    <label>Email: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="email" placeholder="Email Address" class="form-control" value="<?php echo e($usr->email); ?>">
                                                    </div>
                                                    <label>Perfil: </label>
                                                    <div class="form-group">
                                                        <select name="role_id" class="form-control">
                                                            <option value="0" >- Selecione um Perfil -</option>
                                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $onerole): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($onerole->id); ?>" <?php echo e(($onerole->id == $usr->role_id)?'selected':''); ?>><?php echo e($onerole->role); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                                    <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                

                                
                                <div class="modal fade text-left" id="status-<?php echo e($usr->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="myModalLabel33"><?php echo e($usr->name); ?> - <?php echo e(($usr->active==1)?'Desativar':'Ativar'); ?></h4>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <form action="<?php echo e(url('/usuarios/'.$usr->id.'/mudastatus')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                                    <input type="hidden" name="client_id" value="<?php echo e($usr->client_id); ?>">
                                                    <input type="hidden" name="id" value="<?php echo e($usr->id); ?>">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                                    <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(($usr->active==1)?'Desativar':'Ativar'); ?></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>

            
            <div class="modal fade text-left" id="editclient-<?php echo e($client->id); ?>" tabindex="-1" role="dialog" aria-labelledby="Editar Cliente" style="display: none;" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="editclient">Cliente <?php echo e(formataCNPJ($client->taxnumber)); ?></h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <form action="<?php echo e(route('clientes.editar_nickname', $client->id)); ?>" method="POST">
                            <input type="hidden" name="taxnumber" value="<?php echo e($client->taxnumber); ?>">
                            <input type="hidden" name="id" value="<?php echo e($client->id); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <label>Nome Atual: <?php echo e($client->nickname); ?></label><br/>
                                <label>Novo Nome</label>
                                <div class="form-group">
                                    <input type="text" name="nickname" placeholder="Insira o novo nome" value="<?php echo e($client->nickname); ?>" class="form-control">
                                    <span class="text-muted">A acentuação será removida automaticamente ao salvar</span>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div> 
            

            
            <div class="modal fade" id="modaldesativard0cliente" tabindex="-2" role="dialog" aria-labelledby="titulomodald0cliente" aria-hidden="true" style="display: none;">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="titulomodald0cliente">
                                Desativar D+0 Automático para <?php echo e(formataCNPJ($client->taxnumber)); ?>?
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <form action="<?php echo e(route('clientes.d0automatico.desativar', [
                            'id_cliente' => $client->id,
                            'id_multisafe' => 0
                        ])); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <input type="hidden" name="id" value="<?php echo e($client->id); ?>">
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-outline-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                <button type="submit" class="btn btn-danger waves-effect waves-light">
                                    Desativar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            
            <div class="modal fade" id="modaldesativard1cliente" tabindex="-2" role="dialog" aria-labelledby="titulomodald1cliente" aria-hidden="true" style="display: none;">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="titulomodald1cliente">
                                Desativar D+1 Automático para <?php echo e(formataCNPJ($client->taxnumber)); ?>?
                            </h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <form action="<?php echo e(route('clientes.d1automatico.desativar', [
                            'id_cliente' => $client->id,
                            'id_multisafe' => 0,
                        ])); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <input type="hidden" name="id" value="<?php echo e($client->id); ?>">
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-outline-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                <button type="submit" class="btn btn-danger waves-effect waves-light">
                                    Desativar!
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            
            <div class="modal fade text-left" id="cliente_usuario_<?php echo e($client->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel33"><?php echo e($client->nickname); ?> - Novo usuário</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <form action="<?php echo e(url('/usuarios')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">

                                <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">

                                <label>Nome: </label>
                                <div class="form-group">
                                    <input type="text" name="name" placeholder="Nome" class="form-control">
                                </div>

                                <label>Email: </label>
                                <div class="form-group">
                                    <input type="text" name="email" placeholder="Email Address" class="form-control">
                                </div>

                                <label>Perfil: </label>
                                <div class="form-group">
                                    <select name="role_id" class="form-control">
                                        <option value="0" selected>- Selecione um Perfil -</option>
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($role->id); ?>"><?php echo e($role->role); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="font-small-3">
                                    <i class="feather icon-alert-triangle text-warning"></i>&nbsp;<span class="text-danger">Uma senha será gerada e enviada para o email.</span>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            

            
            <div class="modal fade text-left" id="status-<?php echo e($client->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel33"><?php echo e($client->name); ?> - <?php echo e(($client->active==1)?'Desativar':'Ativar'); ?></h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <form action="<?php echo e(url('/clientes/'.$client->id.'/mudastatus')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <input type="hidden" name="id" value="<?php echo e($client->id); ?>">
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(($client->active==1)?'Desativar':'Ativar'); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            

            
            <div class="modal fade text-left" id="inlineForm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel33" style="display: none;" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title" id="myModalLabel33">Novo cliente</h4>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                        <form action="<?php echo e(url('/clientes/novaconta')); ?>" method="POST" onsubmit="return validaCpfCnpj()">
                            <input type="hidden" name="maintaxnumber" value="<?php echo e($client->taxnumber); ?>">
                            <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="modal-body">
                                <label>Nome</label>
                                <div class="form-group">
                                    <input type="text" name="nickname" placeholder="" class="form-control">
                                    <span class="text-muted">A acentuação será removida automaticamente ao salvar</span>
                                </div>

                                <label>CNPJ/CPF</label>
                                <div class="form-group">
                                    <input type="text" name="taxnumber" id="cpfcnpj" placeholder="" class="form-control">
                                </div>

                                <label>Email</label>
                                <div class="form-group">
                                    <input type="text" name="mail" placeholder="" class="form-control">
                                </div>

                                <label>Telefone</label>
                                <div class="form-group">
                                    <input type="text" name="phone" placeholder="" class="form-control">
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-primary waves-effect waves-light" data-dismiss="modal">Fechar</button>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">Salvar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('inlinejs'); ?>
    <script type="text/javascript">
        function submitForm() {
            $('#sincronizasps').submit();
        }

        $(function() {
            $("#payments, #transfers, #billets, #balanceusage, #monthlyfee, #valor").maskMoney({
                prefix:'',
                allowNegative: false,
                thousands:'.',
                decimal:',',
                affixesStay: false,
                allowZero: true
            });
        });

        function sendResetLink(id) {
            $('#sendresetlink'+id).submit();
        }

        var options = {
            onKeyPress: function (cpf, ev, el, op) {
                var masks = ['000.000.000-000', '00.000.000/0000-00'];
                $('#cpfcnpj').mask((cpf.length > 14) ? masks[1] : masks[0], op);
            }
        }

        $('#cpfcnpj').length > 11 ? $('#cpfcnpj').mask('00.000.000/0000-00', options) : $('#cpfcnpj').mask('000.000.000-00#', options);

            function validaCpfCnpj() {

        var val = $('#cpfcnpj').val();

        if (val.length < 15) {
            var cpf = val.trim();

            cpf = cpf.replace(/\./g, '');
            cpf = cpf.replace('-', '');
            cpf = cpf.split('');

            var v1 = 0;
            var v2 = 0;
            var aux = false;

            for (var i = 1; cpf.length > i; i++) {
                if (cpf[i - 1] != cpf[i]) {
                    aux = true;
                }
            }

            if (aux == false) {
                alert('Verifique o CPF/CNPJ');
                return false;
            }

            for (var i = 0, p = 10; (cpf.length - 2) > i; i++, p--) {
                v1 += cpf[i] * p;
            }

            v1 = ((v1 * 10) % 11);

            if (v1 == 10) {
                v1 = 0;
            }

            if (v1 != cpf[9]) {
                alert('Verifique o CPF/CNPJ');
                return false;
            }

            for (var i = 0, p = 11; (cpf.length - 1) > i; i++, p--) {
                v2 += cpf[i] * p;
            }

            v2 = ((v2 * 10) % 11);

            if (v2 == 10) {
                v2 = 0;
            }

            if (v2 != cpf[10]) {
                alert('Verifique o CPF/CNPJ');
                return false;
            } else {
                return true;
            }
        } else if (val.length > 15) {
            var cnpj = val.trim();

            cnpj = cnpj.replace(/\./g, '');
            cnpj = cnpj.replace('-', '');
            cnpj = cnpj.replace('/', '');
            cnpj = cnpj.split('');

            var v1 = 0;
            var v2 = 0;
            var aux = false;

            for (var i = 1; cnpj.length > i; i++) {
                if (cnpj[i - 1] != cnpj[i]) {
                    aux = true;
                }
            }

            if (aux == false) {
                alert('Verifique o CPF/CNPJ');
                return false;
            }

            for (var i = 0, p1 = 5, p2 = 13; (cnpj.length - 2) > i; i++, p1--, p2--) {
                if (p1 >= 2) {
                    v1 += cnpj[i] * p1;
                } else {
                    v1 += cnpj[i] * p2;
                }
            }

            v1 = (v1 % 11);

            if (v1 < 2) {
                v1 = 0;
            } else {
                v1 = (11 - v1);
            }

            if (v1 != cnpj[12]) {
                alert('Verifique o CPF/CNPJ');
                return false;
            }

            for (var i = 0, p1 = 6, p2 = 14; (cnpj.length - 1) > i; i++, p1--, p2--) {
                if (p1 >= 2) {
                    v2 += cnpj[i] * p1;
                } else {
                    v2 += cnpj[i] * p2;
                }
            }

            v2 = (v2 % 11);

            if (v2 < 2) {
                v2 = 0;
            } else {
                v2 = (11 - v2);
            }

            if (v2 != cnpj[13]) {
                alert('Verifique o CPF/CNPJ');
                return false;
            } else {
                return true;
            }
        } else {
            alert('Verifique o CPF/CNPJ');
            return false;
        }
    }

    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.authenticated', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/ssg-bank/resources/views/clients/edit.blade.php ENDPATH**/ ?>