<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description" content="Smart Solutions Group SSG Bank">
    <meta name="keywords" content="Smart Solutions Group SSG Bank Smartsafe">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>SSG Bank</title>
    <link rel="apple-touch-icon" href="<?php echo e(asset('images/ico/apple-icon-120.png')); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('images/favicon.png')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600" rel="stylesheet">

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" href="<?php echo e(asset('css/vendors/css/vendors.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/vendors/css/charts/apexcharts.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/vendors/css/extensions/tether-theme-arrows.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/vendors/css/extensions/tether.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/vendors/css/extensions/shepherd-theme-default.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/vendors/css/extensions/toastr.css')); ?>">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" href="<?php echo e(asset('css/css/bootstrap.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/bootstrap-extended.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/colors.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/components.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/themes/dark-layout.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/themes/semi-dark-layout.css')); ?>">

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" href="<?php echo e(asset('css/css/core/menu/menu-types/horizontal-menu.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/core/colors/palette-gradient.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/pages/dashboard-analytics.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/pages/card-analytics.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/plugins/tour/tour.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/css/plugins/extensions/toastr.min.css')); ?>">
    <!-- END: Page CSS-->

    <?php echo $__env->yieldContent('extracss'); ?>

    <!-- BEGIN: Custom CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/style.css')); ?>">
    <!-- END: Custom CSS-->

</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="horizontal-layout horizontal-menu 2-columns  navbar-floating footer-static  " data-open="hover" data-menu="horizontal-menu" data-col="2-columns">

    <!-- BEGIN: Header-->
    <nav class="header-navbar navbar-expand-lg navbar navbar-with-menu navbar-fixed navbar-shadow navbar-brand-center no-print">
        <div class="navbar-header d-xl-block d-none">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item"><a class="navbar-brand" href="<?php echo e(URL('/home')); ?>">
                         <img src="<?php echo e(asset('images/logo.png')); ?>" alt="branding logo">
                    </a></li>
            </ul>
        </div>
        <div class="navbar-wrapper">
            <div class="navbar-container content">
                <div class="navbar-collapse" id="navbar-mobile">
                    <div class="mr-auto float-left bookmark-wrapper d-flex align-items-center">
                        <ul class="nav navbar-nav">
                            <li class="nav-item mobile-menu d-xl-none mr-auto"><a class="nav-link nav-menu-main menu-toggle hidden-xs" href="#"><i class="ficon feather icon-menu"></i></a></li>
                        </ul>
                    </div>
                    <ul class="nav navbar-nav float-right">
                        <!-- <li class="nav-item d-none d-lg-block"><a class="nav-link nav-link-expand"><i class="ficon feather icon-maximize"></i></a></li>
                        <li class="dropdown dropdown-notification nav-item"><a class="nav-link nav-link-label" href="#" data-toggle="dropdown"><i class="ficon feather icon-bell"></i><span class="badge badge-pill badge-primary badge-up">5</span></a>
                            <ul class="dropdown-menu dropdown-menu-media dropdown-menu-right">
                                <li class="dropdown-menu-header">
                                    <div class="dropdown-header m-0 p-2">
                                        <h3 class="white">5 New</h3><span class="notification-title">App Notifications</span>
                                    </div>
                                </li>
                                <li class="scrollable-container media-list"><a class="d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="media d-flex align-items-start">
                                            <div class="media-left"><i class="feather icon-plus-square font-medium-5 primary"></i></div>
                                            <div class="media-body">
                                                <h6 class="primary media-heading">You have new order!</h6><small class="notification-text"> Are your going to meet me tonight?</small>
                                            </div><small>
                                                <time class="media-meta" datetime="2015-06-11T18:29:20+08:00">9 hours ago</time></small>
                                        </div>
                                    </a><a class="d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="media d-flex align-items-start">
                                            <div class="media-left"><i class="feather icon-download-cloud font-medium-5 success"></i></div>
                                            <div class="media-body">
                                                <h6 class="success media-heading red darken-1">99% Server load</h6><small class="notification-text">You got new order of goods.</small>
                                            </div><small>
                                                <time class="media-meta" datetime="2015-06-11T18:29:20+08:00">5 hour ago</time></small>
                                        </div>
                                    </a><a class="d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="media d-flex align-items-start">
                                            <div class="media-left"><i class="feather icon-alert-triangle font-medium-5 danger"></i></div>
                                            <div class="media-body">
                                                <h6 class="danger media-heading yellow darken-3">Warning notifixation</h6><small class="notification-text">Server have 99% CPU usage.</small>
                                            </div><small>
                                                <time class="media-meta" datetime="2015-06-11T18:29:20+08:00">Today</time></small>
                                        </div>
                                    </a><a class="d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="media d-flex align-items-start">
                                            <div class="media-left"><i class="feather icon-check-circle font-medium-5 info"></i></div>
                                            <div class="media-body">
                                                <h6 class="info media-heading">Complete the task</h6><small class="notification-text">Cake sesame snaps cupcake</small>
                                            </div><small>
                                                <time class="media-meta" datetime="2015-06-11T18:29:20+08:00">Last week</time></small>
                                        </div>
                                    </a><a class="d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="media d-flex align-items-start">
                                            <div class="media-left"><i class="feather icon-file font-medium-5 warning"></i></div>
                                            <div class="media-body">
                                                <h6 class="warning media-heading">Generate monthly report</h6><small class="notification-text">Chocolate cake oat cake tiramisu marzipan</small>
                                            </div><small>
                                                <time class="media-meta" datetime="2015-06-11T18:29:20+08:00">Last month</time></small>
                                        </div>
                                    </a></li>
                                <li class="dropdown-menu-footer"><a class="dropdown-item p-1 text-center" href="javascript:void(0)">Read all notifications</a></li>
                            </ul>
                        </li> -->
                        <li class="dropdown dropdown-user nav-item">
                            <a class="dropdown-toggle nav-link dropdown-user-link" href="#" data-toggle="dropdown">
                                <div class="user-nav d-sm-flex d-none text-right">
                                    <span class="user-name text-bold-600 text-primary"><br><?php echo e(Auth::User()->name); ?><br><small class="text-muted">Último acesso: <?php echo e(getUserLastAccess()); ?></small></span>
                                </div>
                                <!-- <span><img class="round" src="images/portrait/small/avatar-s-11.jpg" alt="avatar" height="40" width="40"></span> -->
                            </a>
                            <div class="dropdown-menu dropdown-menu-right">
                                
                                
                                <a class="dropdown-item" href="<?php echo e(url('/usuario/mudarsenha')); ?>"><i class="feather icon-settings"></i><span data-i18n="Mudar senha">Mudar senha</span></a>
                                <?php if(Auth::user()->role_id == 1): ?>
                                    <a class="dropdown-item" href="<?php echo e(url('/spsinfo')); ?>"><i class="feather icon-settings"></i><span data-i18n="Configurações">Configurações</span></a>
                                <?php else: ?>
                                    <a class="dropdown-item" href="<?php echo e(url('clientes/'.Auth::User()->client_id.'/informacoes')); ?>"><i class="feather icon-info"></i>Informações</a>
                                <?php endif; ?>
                                <a class="dropdown-item" href="<?php echo e(url('logout')); ?>"><i class="feather icon-power"></i>Logout</a>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>
    <!-- END: Header-->


    <!-- BEGIN: Main Menu-->
    <div class="horizontal-menu-wrapper no-print">
        <div class="header-navbar navbar-expand-sm navbar navbar-horizontal floating-nav navbar-light navbar-without-dd-arrow navbar-shadow menu-border" role="navigation" data-menu="menu-wrapper">
            <div class="navbar-header">
                <ul class="nav navbar-nav flex-row">
                    <li class="nav-item mr-auto"><a class="<?php echo e(url('/')); ?>">
                            <img src="<?php echo e(asset('images/logo.png')); ?>" alt="branding logo">
                        </a></li>
                    <li class="nav-item nav-toggle"><a class="nav-link modern-nav-toggle pr-0" data-toggle="collapse"><i class="feather icon-x d-block d-xl-none font-medium-4 primary toggle-icon"></i><i class="toggle-icon feather icon-disc font-medium-4 d-none d-xl-block collapse-toggle-icon primary" data-ticon="icon-disc"></i></a></li>
                </ul>
            </div>
            <!-- Horizontal menu content-->
            <div class="navbar-container main-menu-content" data-menu="menu-container">
                <!-- include ../../../includes/mixins-->
                <ul class="nav navbar-nav" id="main-menu-navigation" data-menu="menu-navigation" style="margin:0 auto;">

                    <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/home')); ?>"><i class="feather icon-home"></i><span data-i18n="Inicio">Início</span></a></li>

                    <?php if(Auth::user()->role_id == 1): ?>
                        <!-- ADMIN -->
                        
                        


                        <li class="dropdown nav-item" data-menu="dropdown"><a class="dropdown-toggle nav-link" href="#" data-toggle="dropdown"><i class="fa fa-tasks"></i><span data-i18n="SSG">SSG</span></a>
                            <ul class="dropdown-menu">
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/usuarios')); ?>" data-toggle="dropdown" data-i18n="Usuários"><i class="feather icon-users"></i>Usuários</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/ferramentas')); ?>" data-toggle="dropdown" data-i18n="ferramentas"><i class="fa fa-cog"></i>Ferramentas</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/provisionamento')); ?>" data-toggle="dropdown" data-i18n="Provisionamento"><i class="fa fa-cog"></i>Provisionamento</a></li>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('testes.listar')): ?>
                                <li><div class="dropdown-divider"></div></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/testes/listar')); ?>" data-toggle="dropdown" data-i18n="Testes"><i class="fa fa-cog"></i>Testes</a></li>
                                <?php endif; ?>

                                
                            </ul>
                        </li>

                        <li class="dropdown nav-item" data-menu="dropdown"><a class="dropdown-toggle nav-link" href="#" data-toggle="dropdown"><i class="feather icon-layers"></i><span data-i18n="Clientes">Clientes</span></a>
                            <ul class="dropdown-menu">
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/clientes')); ?>" data-toggle="dropdown" data-i18n="clientes"><i class="feather icon-x-circle"></i>Listar</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/mensalidades/ver')); ?>" data-toggle="dropdown" data-i18n="clientes"><i class="feather icon-x-circle"></i>Mensalidades</a></li>
                                
                            </ul>
                        </li>

                        <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/extratosps')); ?>"><i class="fa fa-list"></i><span data-i18n="Extrato">Extrato</span></a></li>

                        <li class="dropdown nav-item" data-menu="dropdown"><a class="dropdown-toggle nav-link" href="#" data-toggle="dropdown"><i class="fa fa-external-link"></i><span data-i18n="Transferência">Transferências</span></a>
                            <ul class="dropdown-menu">
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/transferenciacliente')); ?>" data-toggle="dropdown" data-i18n="Transferir"><i class="feather icon-user"></i>Simples</a></li>
                                <?php if(auth()->user()->isMaster()): ?>
                                    <li data-menu="">
                                        <a class="dropdown-item"
                                           href="<?php echo e(route('transferencia.cliente')); ?>"
                                           data-toggle="dropdown"
                                           data-i18n="Transferir">
                                            <i class="feather icon-user"></i>
                                            Simples
                                            <i class="badge-success" style="margin-left: 12px; padding: 4px 8px;
                                            border-radius:
                                            8px;
                                            ">novo</i>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/transferencia-visao-geral')); ?>" data-toggle="dropdown" data-i18n="Transferência Visão"><i class="feather icon-user"></i>Detalhada</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/transferenciarapida')); ?>" data-toggle="dropdown" data-i18n="Transferência rápida"><i class="feather icon-user"></i>Rápida</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/transferenciainterna')); ?>" data-toggle="dropdown" data-i18n="Transferência interna"><i class="feather icon-user"></i>Interna</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/logtransferencias')); ?>" data-toggle="dropdown" data-i18n="Consultar transferências"><i class="feather icon-user"></i>Consultar</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/logs/saldodisponivel')); ?>" data-toggle="dropdown" data-i18n="Saldo disponível"><i class="feather icon-user"></i>Util. Saldo Disp.</a></li>
                            </ul>
                        </li>

                        <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/transferenciasps')); ?>"><i class="fa fa-university"></i><span data-i18n="Transferir SSG">Conta Mãe</span></a></li>

                        

                        <li class="dropdown nav-item" data-menu="dropdown"><a class="dropdown-toggle nav-link" href="#" data-toggle="dropdown"><i class="fa fa-files-o"></i><span data-i18n="Relatórios">Relatórios</span></a>
                            <ul class="dropdown-menu">
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/relatorios/tarifas/simples')); ?>" data-toggle="dropdown" data-i18n="Relatório Simples"><i class="feather icon-x-circle"></i>Simplificado</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/relatorios/tarifas/detalhado')); ?>" data-toggle="dropdown" data-i18n="Relatório detalhado"><i class="feather icon-x-circle"></i>Detalhado</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/relatorios/tarifas/graficos')); ?>" data-toggle="dropdown" data-i18n="Gráficos"><i class="feather icon-x-circle"></i>Gráficos</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/relatorios/tarifas/comparativos')); ?>" data-toggle="dropdown" data-i18n="Comparativos"><i class="feather icon-x-circle"></i>Comparativos</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/relatorios/tarifas/anual')); ?>" data-toggle="dropdown" data-i18n="Anual"><i class="feather icon-x-circle"></i>Anual</a></li>
                            </ul>
                        </li>


                        <li class="dropdown nav-item" data-menu="dropdown"><a class="dropdown-toggle nav-link" href="#" data-toggle="dropdown"><i class="feather icon-layers"></i><span data-i18n="Logs">Logs</span></a>
                            <ul class="dropdown-menu">
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/logs/pagamentos')); ?>" data-toggle="dropdown" data-i18n="Pagamentos"><i class="feather icon-x-circle"></i>Pagamentos</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/logs/boletos')); ?>" data-toggle="dropdown" data-i18n="Boletos"><i class="feather icon-x-circle"></i>Boletos</a></li>
                                
                                <li><div class="dropdown-divider"></div></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/logs/transacoesfit')); ?>" data-toggle="dropdown" data-i18n="Transações FIT"><i class="feather icon-x-circle"></i>Transações FIT</a></li>

                            </ul>
                        </li>


                        <!-- /ADMIN -->
                        <?php else: ?>

                        <li class="dropdown nav-item" data-menu="dropdown"><a class="dropdown-toggle nav-link" href="#" data-toggle="dropdown"><i class="feather icon-repeat"></i><span data-i18n="UI Elements">
                        Transferências</span></a>
                            <ul class="dropdown-menu">
                                
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transferencia.bancaria.gerenciar')): ?>
                                <li class="dropdown dropdown-submenu" data-menu="dropdown-submenu">
                                    <a class="dropdown-item dropdown-toggle" href="#" data-toggle="dropdown"><span data-i18n="darf"><i class="feather icon-chevron-right"></i>
                                    para Contas Externas</span></a>
                                    <ul class="dropdown-menu">

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transferencia.bancaria.gerenciar.transferir')): ?>
                                        <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/transferencias')); ?>" data-toggle="dropdown" data-i18n="Transferir"><i class="feather icon-chevron-right"></i>
                                        Transferir</a></li>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transferencia.bancaria.gerenciar.incluir')): ?>
                                        <li data-menu="">
                                            <a class="dropdown-item" href="<?php echo e(url('/transferencias/bancaria/inclusao')); ?>" data-toggle="dropdown" data-i18n="Incluir Transferencia"><i class="feather icon-chevron-right"></i>
                                            Incluir Transferência</a></li>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transferencia.bancaria.gerenciar.autorizar.consulta')): ?>
                                        <li data-menu="">
                                            <a class="dropdown-item" href="<?php echo e(url('/transferencias/bancaria/autorizar')); ?>" data-toggle="dropdown" data-i18n="Autorizar Transferencia"><i class="feather icon-chevron-right"></i>
                                            Autorizar Transferência</a></li>
                                        <?php endif; ?>

                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transferencia.bancaria.gerenciar.consultar')): ?>
                                        <li data-menu="">
                                            <a class="dropdown-item" href="<?php echo e(url('/transferencias/bancaria/consultar')); ?>" data-toggle="dropdown" data-i18n="Consultar Transferencia"><i class="feather icon-chevron-right"></i>
                                            Consultar</a></li>
                                        <?php endif; ?>
                                    </ul>
                                </li>
                                <?php endif; ?>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('transferencia.bancaria.gerenciar')): ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transferencia.bancaria.gerenciar.transferir')): ?>
                                        <li data-menu="">
                                            <a class="dropdown-item" href="<?php echo e(url('/transferencias')); ?>" data-toggle="dropdown" data-i18n="Transferir"><i class="feather icon-user"></i>
                                            Transferir</a></li>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <li data-menu="">
                                    <a class="dropdown-item" href="<?php echo e(url('/transferenciainterna')); ?>" data-toggle="dropdown" data-i18n="Transferir entre Contas SSG"><i class="feather icon-user"></i>
                                    Transferir entre Contas SSG</a></li>

                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->denies('transferencia.bancaria.gerenciar')): ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transferencia.bancaria.gerenciar.consultar')): ?>
                                    <li data-menu="">
                                        <a class="dropdown-item" href="<?php echo e(url('/transferencias/consulta')); ?>" data-toggle="dropdown" data-i18n="Consultar Transferencia"><i class="feather icon-user"></i>
                                        Consultar</a></li>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <li data-menu="">
                                    <a class="dropdown-item" id="consultarAgendamentos" href="<?php echo e(route('transferencias.agendamento.consultar')); ?>" data-toggle="dropdown" data-i18n="Consultar Agendamentos">
                                        <i class="feather icon-user"></i>
                                        Cancelar Agendamentos
                                    </a>
                                </li>
                            </ul>
                        </li>

                        <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/extrato')); ?>"><i class="fa fa-list"></i><span data-i18n="Extrato">Extrato</span></a></li>

                        <li class="dropdown nav-item" data-menu="dropdown"><a class="dropdown-toggle nav-link" href="#" data-toggle="dropdown"><i class="feather icon-file"></i><span data-i18n="Pages">Boletos</span></a>
                            <ul class="dropdown-menu">
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/clientes/boletos/avulso')); ?>" data-toggle="dropdown" data-i18n="Boletos"><i class="feather icon-user"></i>Avulso</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/contatos/cliente')); ?>" data-toggle="dropdown" data-i18n="Boletos"><i class="feather icon-user"></i>Para contatos</a></li>
                                <li data-menu=""><a class="dropdown-item" href="<?php echo e(url('/clientes/boletos/consultar')); ?>" data-toggle="dropdown" data-i18n="Boletos"><i class="feather icon-user"></i>Consultar</a></li>
                            </ul>
                        </li>

                        <li class="nav-item"><a class="nav-link" href="<?php echo e(url('/contatos/cliente')); ?>"><i class="feather icon-users"></i><span data-i18n="Contatos">Contatos</span></a></li>
                    <?php endif; ?>


                </ul>
            </div>
        </div>
    </div>
    <!-- END: Main Menu-->

    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay no-print"></div>
        <div class="header-navbar-shadow no-print"></div>
        <div class="content-wrapper">
            <div class="content-body">
                

                <?php echo $__env->yieldContent('content'); ?>

            </div>
        </div>
    </div>
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Footer-->
    <footer class="footer footer-static footer-light navbar-shadow">
        <p class="clearfix blue-grey lighten-2 mb-0"><span class="float-md-left d-block d-md-inline-block mt-25">&copy; 2020 - Smart Payment Solutions</span></p>
    </footer>
    <!-- END: Footer-->


    <!-- BEGIN: Vendor JS-->
    <script src="<?php echo e(asset('js/vendors/js/vendors.min.js')); ?>"></script>
    <!-- BEGIN Vendor JS-->

    <!-- BEGIN: Page Vendor JS-->
    <script src="<?php echo e(asset('js/vendors/js/ui/jquery.sticky.js')); ?>"></script>
    <script src="<?php echo e(asset('js/vendors/js/charts/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/vendors/js/extensions/tether.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/vendors/js/extensions/shepherd.min.js')); ?>"></script>
    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="<?php echo e(asset('js/js/core/app-menu.js')); ?>"></script>
    <script src="<?php echo e(asset('js/js/core/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/js/scripts/components.js')); ?>"></script>
    <script src="<?php echo e(asset('js/vendors/js/extensions/toastr.min.js')); ?>"></script>
    <!-- END: Theme JS-->

    <!-- BEGIN: Page JS-->
    <!-- <script src="<?php echo e(asset('js/js/scripts/pages/dashboard-analytics.js')); ?>"></script> -->
    <!-- END: Page JS-->


    <script>
      $('#alertmessage').fadeOut(15000, function(){
           $(this).remove();
      });

        <?php if(session('success')): ?>
                toastr.success('<?php echo e(session('success')); ?>', 'Sucesso!', { "progressBar": true, positionClass: 'toast-top-full-width' });
        <?php endif; ?>

        <?php if(session('status')): ?>
                toastr.warning( '<?php echo e(session('status')); ?>', 'Notificação', { "progressBar": true, positionClass: 'toast-top-full-width' });
        <?php endif; ?>

        <?php if(session('warning')): ?>
                toastr.error('<?php echo e(session('warning')); ?>', 'Aviso!', { "progressBar": true, positionClass: 'toast-top-full-width' });
        <?php endif; ?>

    </script>

    <?php echo $__env->yieldContent('extrajs'); ?>
    <?php echo $__env->yieldContent('inlinejs'); ?>

</body>
<!-- END: Body-->

</html>
<?php /**PATH /var/www/ssg-bank/resources/views/layouts/authenticated.blade.php ENDPATH**/ ?>